/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class TsFileMetricManager {
    private static final TsFileMetricManager INSTANCE = new TsFileMetricManager();
    private AtomicLong seqFileSize = new AtomicLong(0L);
    private AtomicLong unseqFileSize = new AtomicLong(0L);
    private AtomicInteger seqFileNum = new AtomicInteger(0);
    private AtomicInteger unseqFileNum = new AtomicInteger(0);

    private TsFileMetricManager() {
    }

    public static TsFileMetricManager getInstance() {
        return INSTANCE;
    }

    public void addFile(long size, boolean seq) {
        if (seq) {
            this.seqFileSize.getAndAdd(size);
            this.seqFileNum.incrementAndGet();
        } else {
            this.unseqFileSize.getAndAdd(size);
            this.unseqFileNum.incrementAndGet();
        }
    }

    public void deleteFile(long size, boolean seq, int num) {
        if (seq) {
            this.seqFileSize.getAndAdd(-size);
            this.seqFileNum.getAndAdd(-num);
        } else {
            this.unseqFileSize.getAndAdd(-size);
            this.unseqFileNum.getAndAdd(-num);
        }
    }

    public long getFileSize(boolean seq) {
        return seq ? this.seqFileSize.get() : this.unseqFileSize.get();
    }

    public long getFileNum(boolean seq) {
        return seq ? (long)this.seqFileNum.get() : (long)this.unseqFileNum.get();
    }
}

