/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.balancer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.confignode.client.async.AsyncDataNodeClientPool;
import org.apache.iotdb.confignode.client.async.handlers.AsyncClientHandler;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.load.balancer.router.RegionRouteMap;
import org.apache.iotdb.confignode.manager.load.balancer.router.leader.GreedyLeaderBalancer;
import org.apache.iotdb.confignode.manager.load.balancer.router.leader.ILeaderBalancer;
import org.apache.iotdb.confignode.manager.load.balancer.router.leader.MinCostFlowLeaderBalancer;
import org.apache.iotdb.confignode.manager.load.balancer.router.priority.GreedyPriorityBalancer;
import org.apache.iotdb.confignode.manager.load.balancer.router.priority.IPriorityBalancer;
import org.apache.iotdb.confignode.manager.load.balancer.router.priority.LeaderPriorityBalancer;
import org.apache.iotdb.confignode.manager.node.NodeManager;
import org.apache.iotdb.confignode.manager.partition.PartitionManager;
import org.apache.iotdb.mpp.rpc.thrift.TRegionLeaderChangeReq;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteBalancer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RouteBalancer.class);
    private static final ConfigNodeConfig CONF = ConfigNodeDescriptor.getInstance().getConf();
    private static final String SCHEMA_REGION_CONSENSUS_PROTOCOL_CLASS = CONF.getSchemaRegionConsensusProtocolClass();
    private static final String DATA_REGION_CONSENSUS_PROTOCOL_CLASS = CONF.getDataRegionConsensusProtocolClass();
    private static final boolean IS_ENABLE_AUTO_LEADER_BALANCE_FOR_DATA_REGION = CONF.isEnableAutoLeaderBalanceForRatisConsensus() && "org.apache.iotdb.consensus.ratis.RatisConsensus".equals(DATA_REGION_CONSENSUS_PROTOCOL_CLASS) || CONF.isEnableAutoLeaderBalanceForIoTConsensus() && "org.apache.iotdb.consensus.iot.IoTConsensus".equals(DATA_REGION_CONSENSUS_PROTOCOL_CLASS);
    private static final boolean IS_ENABLE_AUTO_LEADER_BALANCE_FOR_SCHEMA_REGION = CONF.isEnableAutoLeaderBalanceForRatisConsensus() && "org.apache.iotdb.consensus.ratis.RatisConsensus".equals(SCHEMA_REGION_CONSENSUS_PROTOCOL_CLASS) || CONF.isEnableAutoLeaderBalanceForIoTConsensus() && "org.apache.iotdb.consensus.iot.IoTConsensus".equals(SCHEMA_REGION_CONSENSUS_PROTOCOL_CLASS);
    private static final boolean IS_DATA_REGION_IOT_CONSENSUS = "org.apache.iotdb.consensus.iot.IoTConsensus".equals(DATA_REGION_CONSENSUS_PROTOCOL_CLASS);
    private final IManager configManager;
    private final Map<TConsensusGroupId, Pair<Long, Integer>> leaderCache;
    private final RegionRouteMap regionRouteMap;
    private final ILeaderBalancer leaderBalancer;
    private final IPriorityBalancer priorityRouter;
    private Future<?> currentLeaderBalancingFuture;
    private final ScheduledExecutorService leaderBalancingExecutor = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)"Cluster-LeaderBalancing-Service");
    private final Object scheduleMonitor = new Object();

    public RouteBalancer(IManager configManager) {
        this.configManager = configManager;
        this.leaderCache = new ConcurrentHashMap<TConsensusGroupId, Pair<Long, Integer>>();
        this.regionRouteMap = new RegionRouteMap();
        switch (CONF.getLeaderDistributionPolicy()) {
            case "GREEDY": {
                this.leaderBalancer = new GreedyLeaderBalancer();
                break;
            }
            default: {
                this.leaderBalancer = new MinCostFlowLeaderBalancer();
            }
        }
        switch (CONF.getRoutePriorityPolicy()) {
            case "GREEDY": {
                this.priorityRouter = new GreedyPriorityBalancer();
                break;
            }
            default: {
                this.priorityRouter = new LeaderPriorityBalancer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheLeaderSample(TConsensusGroupId regionGroupId, Pair<Long, Integer> leaderSample) {
        if (TConsensusGroupType.DataRegion.equals((Object)regionGroupId.getType()) && IS_DATA_REGION_IOT_CONSENSUS) {
            return;
        }
        this.leaderCache.putIfAbsent(regionGroupId, leaderSample);
        Pair<Long, Integer> pair = this.leaderCache.get(regionGroupId);
        synchronized (pair) {
            if ((Long)this.leaderCache.get(regionGroupId).getLeft() < (Long)leaderSample.getLeft()) {
                this.leaderCache.replace(regionGroupId, leaderSample);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateRegionRouteMap() {
        RegionRouteMap regionRouteMap = this.regionRouteMap;
        synchronized (regionRouteMap) {
            return this.updateRegionLeaderMap() | this.updateRegionPriorityMap();
        }
    }

    private boolean updateRegionLeaderMap() {
        AtomicBoolean isLeaderChanged = new AtomicBoolean(false);
        this.leaderCache.forEach((regionGroupId, leadershipSample) -> {
            if (TConsensusGroupType.DataRegion.equals((Object)regionGroupId.getType()) && IS_DATA_REGION_IOT_CONSENSUS) {
                return;
            }
            if (((Integer)leadershipSample.getRight()).intValue() != this.regionRouteMap.getLeader((TConsensusGroupId)regionGroupId)) {
                this.regionRouteMap.setLeader((TConsensusGroupId)regionGroupId, (Integer)leadershipSample.getRight());
                isLeaderChanged.set(true);
            }
        });
        return isLeaderChanged.get();
    }

    private boolean updateRegionPriorityMap() {
        Map<TConsensusGroupId, Integer> regionLeaderMap = this.regionRouteMap.getRegionLeaderMap();
        Map<Integer, Long> dataNodeLoadScoreMap = this.getNodeManager().getAllLoadScores();
        Map<TConsensusGroupId, TRegionReplicaSet> latestRegionPriorityMap = this.priorityRouter.generateOptimalRoutePriority(this.getPartitionManager().getAllReplicaSets(TConsensusGroupType.SchemaRegion), regionLeaderMap, dataNodeLoadScoreMap);
        latestRegionPriorityMap.putAll(this.priorityRouter.generateOptimalRoutePriority(this.getPartitionManager().getAllReplicaSets(TConsensusGroupType.DataRegion), regionLeaderMap, dataNodeLoadScoreMap));
        if (!latestRegionPriorityMap.equals(this.regionRouteMap.getRegionPriorityMap())) {
            this.regionRouteMap.setRegionPriorityMap(latestRegionPriorityMap);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void greedySelectLeader(TConsensusGroupId regionGroupId, List<Integer> dataNodeIds) {
        RegionRouteMap regionRouteMap = this.regionRouteMap;
        synchronized (regionRouteMap) {
            HashMap leaderCounter = new HashMap();
            this.regionRouteMap.getRegionLeaderMap().forEach((consensusGroupId, leaderId) -> {
                if (TConsensusGroupType.DataRegion.equals((Object)consensusGroupId.getType())) {
                    leaderCounter.computeIfAbsent(leaderId, empty -> new AtomicInteger(0)).getAndIncrement();
                }
            });
            int newLeaderId = -1;
            int minCount = Integer.MAX_VALUE;
            AtomicInteger zero = new AtomicInteger(0);
            for (int dataNodeId : dataNodeIds) {
                int leaderCount = leaderCounter.getOrDefault(dataNodeId, zero).get();
                if (leaderCount >= minCount) continue;
                newLeaderId = dataNodeId;
                minCount = leaderCount;
            }
            this.regionRouteMap.setLeader(regionGroupId, newLeaderId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRouteBalancingService() {
        Object object = this.scheduleMonitor;
        synchronized (object) {
            if (this.currentLeaderBalancingFuture == null) {
                this.currentLeaderBalancingFuture = ScheduledExecutorUtil.safelyScheduleWithFixedDelay((ScheduledExecutorService)this.leaderBalancingExecutor, this::balancingRegionLeader, (long)0L, (long)(NodeManager.HEARTBEAT_INTERVAL * 20L), (TimeUnit)TimeUnit.MILLISECONDS);
                LOGGER.info("Route-Balancing service is started successfully.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRouteBalancingService() {
        Object object = this.scheduleMonitor;
        synchronized (object) {
            if (this.currentLeaderBalancingFuture != null) {
                this.currentLeaderBalancingFuture.cancel(false);
                this.currentLeaderBalancingFuture = null;
                this.leaderCache.clear();
                this.regionRouteMap.clear();
                LOGGER.info("Route-Balancing service is stopped successfully.");
            }
        }
    }

    private void balancingRegionLeader() {
        if (IS_ENABLE_AUTO_LEADER_BALANCE_FOR_SCHEMA_REGION) {
            this.balancingRegionLeader(TConsensusGroupType.SchemaRegion);
        }
        if (IS_ENABLE_AUTO_LEADER_BALANCE_FOR_DATA_REGION) {
            this.balancingRegionLeader(TConsensusGroupType.DataRegion);
        }
    }

    private void balancingRegionLeader(TConsensusGroupType regionGroupType) {
        Map<TConsensusGroupId, Integer> leaderDistribution = this.leaderBalancer.generateOptimalLeaderDistribution(this.getPartitionManager().getAllReplicaSetsMap(regionGroupType), this.regionRouteMap.getRegionLeaderMap(), this.getNodeManager().filterDataNodeThroughStatus(NodeStatus.Unknown, NodeStatus.ReadOnly, NodeStatus.Removing).stream().map(TDataNodeConfiguration::getLocation).map(TDataNodeLocation::getDataNodeId).collect(Collectors.toSet()));
        AtomicInteger requestId = new AtomicInteger(0);
        AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.CHANGE_REGION_LEADER);
        leaderDistribution.forEach((regionGroupId, newLeaderId) -> {
            if (newLeaderId != -1 && newLeaderId.intValue() != this.regionRouteMap.getLeader((TConsensusGroupId)regionGroupId)) {
                String consensusProtocolClass;
                switch (regionGroupId.getType()) {
                    case SchemaRegion: {
                        consensusProtocolClass = SCHEMA_REGION_CONSENSUS_PROTOCOL_CLASS;
                        break;
                    }
                    default: {
                        consensusProtocolClass = DATA_REGION_CONSENSUS_PROTOCOL_CLASS;
                    }
                }
                LOGGER.info("[LeaderBalancer] Try to change the leader of Region: {} to DataNode: {} ", regionGroupId, newLeaderId);
                this.changeRegionLeader(consensusProtocolClass, requestId, clientHandler, (TConsensusGroupId)regionGroupId, this.getNodeManager().getRegisteredDataNode((int)newLeaderId).getLocation());
            }
        });
        if (requestId.get() > 0) {
            AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler, 1);
        }
    }

    public void changeLeaderForIoTConsensus(TConsensusGroupId regionGroupId, int newLeaderId) {
        this.regionRouteMap.setLeader(regionGroupId, newLeaderId);
    }

    private void changeRegionLeader(String consensusProtocolClass, AtomicInteger requestId, AsyncClientHandler<TRegionLeaderChangeReq, TSStatus> clientHandler, TConsensusGroupId regionGroupId, TDataNodeLocation newLeader) {
        switch (consensusProtocolClass) {
            case "org.apache.iotdb.consensus.iot.IoTConsensus": {
                this.regionRouteMap.setLeader(regionGroupId, newLeader.getDataNodeId());
                break;
            }
            default: {
                TRegionLeaderChangeReq regionLeaderChangeReq = new TRegionLeaderChangeReq(regionGroupId, newLeader);
                int requestIndex = requestId.getAndIncrement();
                clientHandler.putRequest(requestIndex, regionLeaderChangeReq);
                clientHandler.putDataNodeLocation(requestIndex, newLeader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initRegionRouteMap() {
        RegionRouteMap regionRouteMap = this.regionRouteMap;
        synchronized (regionRouteMap) {
            this.regionRouteMap.clear();
            if (IS_DATA_REGION_IOT_CONSENSUS) {
                List<TRegionReplicaSet> dataRegionGroups = this.getPartitionManager().getAllReplicaSets(TConsensusGroupType.DataRegion);
                for (TRegionReplicaSet dataRegionGroup : dataRegionGroups) {
                    this.greedySelectLeader(dataRegionGroup.getRegionId(), dataRegionGroup.getDataNodeLocations().stream().map(TDataNodeLocation::getDataNodeId).collect(Collectors.toList()));
                }
            }
            this.updateRegionRouteMap();
        }
    }

    public Map<TConsensusGroupId, Integer> getLatestRegionLeaderMap() {
        return this.regionRouteMap.getRegionLeaderMap();
    }

    public Map<TConsensusGroupId, TRegionReplicaSet> getLatestRegionPriorityMap() {
        return this.regionRouteMap.getRegionPriorityMap();
    }

    public RegionRouteMap getRegionRouteMap() {
        return this.regionRouteMap;
    }

    private NodeManager getNodeManager() {
        return this.configManager.getNodeManager();
    }

    private PartitionManager getPartitionManager() {
        return this.configManager.getPartitionManager();
    }
}

