/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.storagegroup;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.commons.utils.BasicStructureSerDeUtil;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;

public class SetTTLPlan
extends ConfigPhysicalPlan {
    private String[] storageGroupPathPattern;
    private long TTL;

    public SetTTLPlan() {
        super(ConfigPhysicalPlanType.SetTTL);
    }

    public SetTTLPlan(List<String> storageGroupPathPattern, long TTL) {
        this();
        this.storageGroupPathPattern = storageGroupPathPattern.toArray(new String[0]);
        this.TTL = TTL;
    }

    public String[] getStorageGroupPathPattern() {
        return this.storageGroupPathPattern;
    }

    public long getTTL() {
        return this.TTL;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        stream.writeInt(this.storageGroupPathPattern.length);
        for (String node : this.storageGroupPathPattern) {
            BasicStructureSerDeUtil.write((String)node, (DataOutputStream)stream);
        }
        stream.writeLong(this.TTL);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        int length = buffer.getInt();
        this.storageGroupPathPattern = new String[length];
        for (int i = 0; i < length; ++i) {
            this.storageGroupPathPattern[i] = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
        }
        this.TTL = buffer.getLong();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetTTLPlan setTTLPlan = (SetTTLPlan)o;
        return this.TTL == setTTLPlan.TTL && Arrays.equals(this.storageGroupPathPattern, setTTLPlan.storageGroupPathPattern);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.storageGroupPathPattern, this.TTL);
    }
}

