/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.function;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.commons.udf.UDFInformation;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class CreateFunctionPlan
extends ConfigPhysicalPlan {
    private UDFInformation udfInformation;
    private Binary jarFile;

    public CreateFunctionPlan() {
        super(ConfigPhysicalPlanType.CreateFunction);
    }

    public CreateFunctionPlan(UDFInformation udfInformation, Binary jarFile) {
        super(ConfigPhysicalPlanType.CreateFunction);
        this.udfInformation = udfInformation;
        this.jarFile = jarFile;
    }

    public UDFInformation getUdfInformation() {
        return this.udfInformation;
    }

    public Binary getJarFile() {
        return this.jarFile;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        this.udfInformation.serialize(stream);
        if (this.jarFile == null) {
            ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((Boolean)false, (OutputStream)stream);
            ReadWriteIOUtils.write((Binary)this.jarFile, (OutputStream)stream);
        }
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.udfInformation = UDFInformation.deserialize((ByteBuffer)buffer);
        if (ReadWriteIOUtils.readBool((ByteBuffer)buffer)) {
            return;
        }
        this.jarFile = ReadWriteIOUtils.readBinary((ByteBuffer)buffer);
    }
}

