/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.tool.upgrade;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.tool.upgrade.TsfileUpgradeToolV0_8_0;

public class UpgradeTool {
    public static void upgradeTsfiles(String dir, String upgradeDir, int threadNum) throws IOException {
        File file = FSFactoryProducer.getFSFactory().getFile(dir);
        LinkedList<File> tmp = new LinkedList<File>();
        tmp.add(file);
        ArrayList<String> tsfiles = new ArrayList<String>();
        if (file.exists()) {
            while (!tmp.isEmpty()) {
                File tmp_file = (File)tmp.poll();
                File[] files = tmp_file.listFiles();
                for (File file2 : files) {
                    if (file2.isDirectory()) {
                        tmp.add(file2);
                        continue;
                    }
                    if (file2.getName().endsWith(".tsfile")) {
                        tsfiles.add(file2.getAbsolutePath());
                    }
                    if (!file2.getName().endsWith(".resource")) continue;
                    File newFileName = FSFactoryProducer.getFSFactory().getFile(file2.getAbsoluteFile().toString().replace(dir, upgradeDir));
                    if (!newFileName.getParentFile().exists()) {
                        newFileName.getParentFile().mkdirs();
                    }
                    newFileName.createNewFile();
                    FileUtils.copyFile((File)file2, (File)newFileName);
                }
            }
        }
        System.out.println(String.format("begin upgrade the data dir:%s, the total num of the tsfiles that need to be upgraded:%s", dir, tsfiles.size()));
        AtomicInteger dirUpgradeFileNum = new AtomicInteger(tsfiles.size());
        ExecutorService offlineUpgradeThreadPool = Executors.newFixedThreadPool(threadNum);
        for (String tsfile : tsfiles) {
            offlineUpgradeThreadPool.submit(() -> {
                try {
                    UpgradeTool.upgradeOneTsfile(tsfile, tsfile.replace(dir, upgradeDir));
                    System.out.println(String.format("upgrade file success, file name:%s, remaining file num:%s", tsfile, dirUpgradeFileNum.decrementAndGet()));
                }
                catch (Exception e) {
                    System.out.println(String.format("meet error when upgrade file:%s", tsfile));
                    e.printStackTrace();
                }
            });
        }
        offlineUpgradeThreadPool.shutdown();
    }

    public static void upgradeOneTsfile(String tsfileName, String updateFileName) throws IOException {
        TsfileUpgradeToolV0_8_0 updater = new TsfileUpgradeToolV0_8_0(tsfileName);
        updater.upgradeFile(updateFileName);
    }
}

