/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.file.metadata.TsDeviceMetadata;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class TsDeviceMetadataIndex {
    private long offset;
    private int len;
    private long startTime;
    private long endTime;

    public TsDeviceMetadataIndex() {
    }

    public TsDeviceMetadataIndex(long offset, int len, TsDeviceMetadata deviceMetadata) {
        this.offset = offset;
        this.len = len;
        this.startTime = deviceMetadata.getStartTime();
        this.endTime = deviceMetadata.getEndTime();
    }

    public static TsDeviceMetadataIndex deserializeFrom(InputStream inputStream) throws IOException {
        TsDeviceMetadataIndex index = new TsDeviceMetadataIndex();
        index.offset = ReadWriteIOUtils.readLong(inputStream);
        index.len = ReadWriteIOUtils.readInt(inputStream);
        index.startTime = ReadWriteIOUtils.readLong(inputStream);
        index.endTime = ReadWriteIOUtils.readLong(inputStream);
        return index;
    }

    public static TsDeviceMetadataIndex deserializeFrom(ByteBuffer buffer) {
        TsDeviceMetadataIndex index = new TsDeviceMetadataIndex();
        index.offset = ReadWriteIOUtils.readLong(buffer);
        index.len = ReadWriteIOUtils.readInt(buffer);
        index.startTime = ReadWriteIOUtils.readLong(buffer);
        index.endTime = ReadWriteIOUtils.readLong(buffer);
        return index;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public int getLen() {
        return this.len;
    }

    public void setLen(int len) {
        this.len = len;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public int serializeTo(OutputStream outputStream) throws IOException {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write(this.offset, outputStream);
        byteLen += ReadWriteIOUtils.write(this.len, outputStream);
        byteLen += ReadWriteIOUtils.write(this.startTime, outputStream);
        return byteLen += ReadWriteIOUtils.write(this.endTime, outputStream);
    }

    public int serializeTo(ByteBuffer buffer) {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write(this.offset, buffer);
        byteLen += ReadWriteIOUtils.write(this.len, buffer);
        byteLen += ReadWriteIOUtils.write(this.startTime, buffer);
        return byteLen += ReadWriteIOUtils.write(this.endTime, buffer);
    }

    public String toString() {
        return "TsDeviceMetadataIndex{offset=" + this.offset + ", len=" + this.len + ", startTime=" + this.startTime + ", endTime=" + this.endTime + '}';
    }
}

