/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.client;

import java.io.PrintStream;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.exception.ArgsErrorException;
import org.apache.iotdb.jdbc.IoTDBConnection;
import org.apache.iotdb.jdbc.IoTDBMetadataResultSet;
import org.apache.iotdb.jdbc.IoTDBQueryResultSet;
import org.apache.iotdb.service.rpc.thrift.ServerProperties;
import org.apache.iotdb.tool.ImportCsv;
import org.apache.thrift.TException;

public abstract class AbstractClient {
    static final String HOST_ARGS = "h";
    static final String HOST_NAME = "host";
    static final String HELP_ARGS = "help";
    static final String PORT_ARGS = "p";
    static final String PORT_NAME = "port";
    static final String PASSWORD_ARGS = "pw";
    private static final String PASSWORD_NAME = "password";
    static final String USERNAME_ARGS = "u";
    static final String USERNAME_NAME = "username";
    private static final String EXECUTE_ARGS = "e";
    private static final String EXECUTE_NAME = "execute";
    static final String ISO8601_ARGS = "disableISO8601";
    static final List<String> AGGREGRATE_TIME_LIST = new ArrayList<String>();
    static final String MAX_PRINT_ROW_COUNT_ARGS = "maxPRC";
    private static final String MAX_PRINT_ROW_COUNT_NAME = "maxPrintRowCount";
    static final String SET_MAX_DISPLAY_NUM = "set max_display_num";
    static final String SET_TIMESTAMP_DISPLAY = "set time_display_type";
    static final String SHOW_TIMESTAMP_DISPLAY = "show time_display_type";
    static final String SET_TIME_ZONE = "set time_zone";
    static final String SHOW_TIMEZONE = "show time_zone";
    static final String SET_FETCH_SIZE = "set fetch_size";
    static final String SHOW_FETCH_SIZE = "show fetch_size";
    private static final String HELP = "help";
    static final String IOTDB_CLI_PREFIX = "IoTDB";
    static final String SCRIPT_HINT = "./start-client.sh(start-client.bat if Windows)";
    static final String QUIT_COMMAND = "quit";
    static final String EXIT_COMMAND = "exit";
    private static final String SHOW_METADATA_COMMAND = "show timeseries";
    static final int MAX_HELP_CONSOLE_WIDTH = 88;
    static final String TIMESTAMP_STR = "Time";
    static final int ISO_DATETIME_LEN = 35;
    private static final String IMPORT_CMD = "import";
    private static final String NEED_NOT_TO_PRINT_TIMESTAMP = "AGGREGATION";
    private static final String DEFAULT_TIME_FORMAT = "default";
    private static String timeFormat = "default";
    static int maxPrintRowCount = 100000;
    private static int fetchSize = 10000;
    static int maxTimeLength = 35;
    static int maxValueLength = 15;
    private static int deviceColumnLength = 20;
    private static int measurementColumnLength = 10;
    private static String GROUPBY_DEVICE_COLUMN_NAME = "Device";
    private static boolean isQuit = false;
    static String TIMESTAMP_PRECISION = "ms";
    private static int[] maxValueLengthForShow = new int[]{75, 45, 8, 8};
    static String formatTime = "%" + maxTimeLength + "s|";
    private static String formatValue = "%" + maxValueLength + "s|";
    private static final int DIVIDING_LINE_LENGTH = 40;
    static String host = "127.0.0.1";
    static String port = "6667";
    static String username;
    static String password;
    static String execute;
    static boolean hasExecuteSQL;
    private static boolean printToConsole;
    static Set<String> keywordSet;
    static ServerProperties properties;
    private static boolean printHeader;
    private static int displayCnt;
    private static final PrintStream SCREEN_PRINTER;
    private static boolean showException;

    static void init() {
        keywordSet.add("-h");
        keywordSet.add("-help");
        keywordSet.add("-p");
        keywordSet.add("-pw");
        keywordSet.add("-u");
        keywordSet.add("-e");
        keywordSet.add("-disableISO8601");
        keywordSet.add("-maxPRC");
    }

    private static void output(ResultSet res, boolean printToConsole, ZoneId zoneId) throws SQLException {
        int cnt = 0;
        boolean printTimestamp = true;
        displayCnt = 0;
        printHeader = false;
        ResultSetMetaData resultSetMetaData = res.getMetaData();
        int colCount = resultSetMetaData.getColumnCount();
        boolean isShow = res instanceof IoTDBMetadataResultSet;
        if (res instanceof IoTDBQueryResultSet) {
            boolean bl = printTimestamp = !((IoTDBQueryResultSet)res).isIgnoreTimeStamp();
        }
        while (cnt < maxPrintRowCount && res.next()) {
            AbstractClient.printRow(printTimestamp, colCount, resultSetMetaData, isShow, res, zoneId);
            if (printToConsole || ++cnt % 10000 != 0) continue;
            AbstractClient.println(cnt);
        }
        if (printToConsole) {
            if (!printHeader) {
                AbstractClient.printBlockLine(printTimestamp, colCount, resultSetMetaData, isShow);
                AbstractClient.printName(printTimestamp, colCount, resultSetMetaData, isShow);
                AbstractClient.printBlockLine(printTimestamp, colCount, resultSetMetaData, isShow);
            } else {
                AbstractClient.printBlockLine(printTimestamp, colCount, resultSetMetaData, isShow);
            }
        }
        if (!res.next()) {
            AbstractClient.printCount(isShow, res, cnt);
        } else {
            AbstractClient.println(String.format("Reach maxPrintRowCount = %s lines", maxPrintRowCount));
        }
    }

    private static String getTimestampPrecision() {
        return TIMESTAMP_PRECISION;
    }

    private static void printCount(boolean isShow, ResultSet res, int cnt) throws SQLException {
        if (isShow) {
            int type = res.getType();
            if (type == IoTDBMetadataResultSet.MetadataType.STORAGE_GROUP.ordinal()) {
                AbstractClient.println("Total storage group number = " + cnt);
            } else if (type == IoTDBMetadataResultSet.MetadataType.TIMESERIES.ordinal()) {
                AbstractClient.println("Total timeseries number = " + cnt);
            }
        } else {
            AbstractClient.println("Total line number = " + cnt);
        }
    }

    private static void printRow(boolean printTimestamp, int colCount, ResultSetMetaData resultSetMetaData, boolean isShow, ResultSet res, ZoneId zoneId) throws SQLException {
        if (!printToConsole) {
            return;
        }
        AbstractClient.printHeader(printTimestamp, colCount, resultSetMetaData, isShow);
        if (isShow) {
            AbstractClient.printShow(colCount, res);
        } else {
            AbstractClient.printRowData(printTimestamp, res, zoneId, resultSetMetaData, colCount);
        }
    }

    private static void printHeader(boolean printTimestamp, int colCount, ResultSetMetaData resultSetMetaData, boolean isShow) throws SQLException {
        if (!printHeader) {
            AbstractClient.printBlockLine(printTimestamp, colCount, resultSetMetaData, isShow);
            AbstractClient.printName(printTimestamp, colCount, resultSetMetaData, isShow);
            AbstractClient.printBlockLine(printTimestamp, colCount, resultSetMetaData, isShow);
            printHeader = true;
        }
    }

    private static void printShow(int colCount, ResultSet res) throws SQLException {
        AbstractClient.print("|");
        for (int i = 1; i <= colCount; ++i) {
            formatValue = "%" + maxValueLengthForShow[i - 1] + "s|";
            AbstractClient.printf(formatValue, res.getString(i));
        }
        AbstractClient.println();
    }

    private static void printRowData(boolean printTimestamp, ResultSet res, ZoneId zoneId, ResultSetMetaData resultSetMetaData, int colCount) throws SQLException {
        if (displayCnt < maxPrintRowCount) {
            AbstractClient.print("|");
            if (printTimestamp) {
                AbstractClient.printf(formatTime, AbstractClient.formatDatetime(res.getLong(TIMESTAMP_STR), zoneId));
            }
            for (int i = 2; i <= colCount; ++i) {
                AbstractClient.printColumnData(resultSetMetaData, res, i, zoneId);
            }
            AbstractClient.println();
            ++displayCnt;
        }
    }

    private static void printColumnData(ResultSetMetaData resultSetMetaData, ResultSet res, int i, ZoneId zoneId) throws SQLException {
        boolean flag = false;
        for (String timeStr : AGGREGRATE_TIME_LIST) {
            if (!resultSetMetaData.getColumnLabel(i).toUpperCase().contains(timeStr.toUpperCase())) continue;
            flag = true;
            break;
        }
        if (flag) {
            try {
                AbstractClient.printf(formatValue, AbstractClient.formatDatetime(res.getLong(i), zoneId));
            }
            catch (Exception e) {
                AbstractClient.printf(formatValue, "null");
                AbstractClient.handleException(e);
            }
        } else if (i == 2 && resultSetMetaData.getColumnName(2).equals(GROUPBY_DEVICE_COLUMN_NAME)) {
            AbstractClient.printf("%" + deviceColumnLength + "s|", res.getString(i));
        } else {
            AbstractClient.printf(formatValue, res.getString(i));
        }
    }

    static Options createOptions() {
        Options options = new Options();
        Option help = new Option("help", false, "Display help information(optional)");
        help.setRequired(false);
        options.addOption(help);
        Option timeFormat = new Option(ISO8601_ARGS, false, "Display timestamp in number(optional)");
        timeFormat.setRequired(false);
        options.addOption(timeFormat);
        Option host = Option.builder((String)HOST_ARGS).argName(HOST_NAME).hasArg().desc("Host Name (optional, default 127.0.0.1)").build();
        options.addOption(host);
        Option port = Option.builder((String)PORT_ARGS).argName(PORT_NAME).hasArg().desc("Port (optional, default 6667)").build();
        options.addOption(port);
        Option username = Option.builder((String)USERNAME_ARGS).argName(USERNAME_NAME).hasArg().desc("User name (required)").required().build();
        options.addOption(username);
        Option password = Option.builder((String)PASSWORD_ARGS).argName(PASSWORD_NAME).hasArg().desc("password (optional)").build();
        options.addOption(password);
        Option execute = Option.builder((String)EXECUTE_ARGS).argName(EXECUTE_NAME).hasArg().desc("execute statement (optional)").build();
        options.addOption(execute);
        Option maxPrintCount = Option.builder((String)MAX_PRINT_ROW_COUNT_ARGS).argName(MAX_PRINT_ROW_COUNT_NAME).hasArg().desc("Maximum number of rows displayed (optional)").build();
        options.addOption(maxPrintCount);
        return options;
    }

    public static String parseLongToDateWithPrecision(DateTimeFormatter formatter, long timestamp, ZoneId zoneid, String timestampPrecision) {
        if (timestampPrecision.equals("ms")) {
            long integerofDate = timestamp / 1000L;
            String digits = Long.toString(timestamp % 1000L);
            ZonedDateTime dateTime = ZonedDateTime.ofInstant(Instant.ofEpochSecond(integerofDate), zoneid);
            String datetime = dateTime.format(formatter);
            int length = digits.length();
            if (length != 3) {
                for (int i = 0; i < 3 - length; ++i) {
                    digits = "0" + digits;
                }
            }
            return datetime.substring(0, 19) + "." + digits + datetime.substring(19);
        }
        if (timestampPrecision.equals("us")) {
            long integerofDate = timestamp / 1000000L;
            String digits = Long.toString(timestamp % 1000000L);
            ZonedDateTime dateTime = ZonedDateTime.ofInstant(Instant.ofEpochSecond(integerofDate), zoneid);
            String datetime = dateTime.format(formatter);
            int length = digits.length();
            if (length != 6) {
                for (int i = 0; i < 6 - length; ++i) {
                    digits = "0" + digits;
                }
            }
            return datetime.substring(0, 19) + "." + digits + datetime.substring(19);
        }
        long integerofDate = timestamp / 1000000000L;
        String digits = Long.toString(timestamp % 1000000000L);
        ZonedDateTime dateTime = ZonedDateTime.ofInstant(Instant.ofEpochSecond(integerofDate), zoneid);
        String datetime = dateTime.format(formatter);
        int length = digits.length();
        if (length != 9) {
            for (int i = 0; i < 9 - length; ++i) {
                digits = "0" + digits;
            }
        }
        return datetime.substring(0, 19) + "." + digits + datetime.substring(19);
    }

    private static String formatDatetime(long timestamp, ZoneId zoneId) {
        switch (timeFormat) {
            case "long": 
            case "number": {
                return Long.toString(timestamp);
            }
            case "default": 
            case "iso8601": {
                return AbstractClient.parseLongToDateWithPrecision(DateTimeFormatter.ISO_OFFSET_DATE_TIME, timestamp, zoneId, AbstractClient.getTimestampPrecision());
            }
        }
        ZonedDateTime dateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(timestamp), zoneId);
        return dateTime.format(DateTimeFormatter.ofPattern(timeFormat));
    }

    static String checkRequiredArg(String arg, String name, CommandLine commandLine, boolean isRequired, String defaultValue) throws ArgsErrorException {
        String str = commandLine.getOptionValue(arg);
        if (str == null) {
            if (isRequired) {
                String msg = String.format("%s: Required values for option '%s' not provided", IOTDB_CLI_PREFIX, name);
                AbstractClient.println(msg);
                AbstractClient.println("Use -help for more information");
                throw new ArgsErrorException(msg);
            }
            if (defaultValue == null) {
                String msg = String.format("%s: Required values for option '%s' is null.", IOTDB_CLI_PREFIX, name);
                throw new ArgsErrorException(msg);
            }
            return defaultValue;
        }
        return str;
    }

    static void setTimeFormat(String newTimeFormat) {
        switch (newTimeFormat.trim().toLowerCase()) {
            case "long": 
            case "number": {
                maxTimeLength = maxValueLength;
                timeFormat = newTimeFormat.trim().toLowerCase();
                break;
            }
            case "default": 
            case "iso8601": {
                maxTimeLength = 35;
                timeFormat = newTimeFormat.trim().toLowerCase();
                break;
            }
            default: {
                new SimpleDateFormat(newTimeFormat.trim());
                maxTimeLength = TIMESTAMP_STR.length() > newTimeFormat.length() ? TIMESTAMP_STR.length() : newTimeFormat.length();
                timeFormat = newTimeFormat;
            }
        }
        formatTime = "%" + maxTimeLength + "s|";
    }

    private static void setFetchSize(String fetchSizeString) {
        long tmp = Long.parseLong(fetchSizeString.trim());
        fetchSize = tmp > Integer.MAX_VALUE || tmp < 0L ? Integer.MAX_VALUE : Integer.parseInt(fetchSizeString.trim());
    }

    static void setMaxDisplayNumber(String maxDisplayNum) {
        long tmp = Long.parseLong(maxDisplayNum.trim());
        maxPrintRowCount = tmp > Integer.MAX_VALUE || tmp < 0L ? Integer.MAX_VALUE : Integer.parseInt(maxDisplayNum.trim());
    }

    private static void printBlockLine(boolean printTimestamp, int colCount, ResultSetMetaData resultSetMetaData, boolean isShowTs) throws SQLException {
        StringBuilder blockLine = new StringBuilder();
        if (isShowTs) {
            blockLine.append("+");
            for (int i = 1; i <= colCount; ++i) {
                blockLine.append(StringUtils.repeat((char)'-', (int)maxValueLengthForShow[i - 1])).append("+");
            }
        } else {
            if (printTimestamp) {
                blockLine.append("+").append(StringUtils.repeat((char)'-', (int)maxTimeLength)).append("+");
            } else {
                blockLine.append("+");
            }
            if (resultSetMetaData.getColumnCount() > 1 && resultSetMetaData.getColumnName(2).equals(GROUPBY_DEVICE_COLUMN_NAME)) {
                maxValueLength = measurementColumnLength;
            } else {
                int tmp = Integer.MIN_VALUE;
                for (int i = 1; i <= colCount; ++i) {
                    int len = resultSetMetaData.getColumnLabel(i).length();
                    tmp = tmp > len ? tmp : len;
                }
                maxValueLength = tmp;
            }
            for (int i = 2; i <= colCount; ++i) {
                if (i == 2 && resultSetMetaData.getColumnName(2).equals(GROUPBY_DEVICE_COLUMN_NAME)) {
                    blockLine.append(StringUtils.repeat((char)'-', (int)deviceColumnLength)).append("+");
                    continue;
                }
                blockLine.append(StringUtils.repeat((char)'-', (int)maxValueLength)).append("+");
            }
        }
        AbstractClient.println(blockLine);
    }

    private static void printName(boolean printTimestamp, int colCount, ResultSetMetaData resultSetMetaData, boolean isShowTs) throws SQLException {
        AbstractClient.print("|");
        if (isShowTs) {
            for (int i = 1; i <= colCount; ++i) {
                formatValue = "%" + maxValueLengthForShow[i - 1] + "s|";
                AbstractClient.printf(formatValue, resultSetMetaData.getColumnName(i));
            }
        } else {
            formatValue = "%" + maxValueLength + "s|";
            if (printTimestamp) {
                AbstractClient.printf(formatTime, TIMESTAMP_STR);
            }
            for (int i = 2; i <= colCount; ++i) {
                if (i == 2 && resultSetMetaData.getColumnName(2).equals(GROUPBY_DEVICE_COLUMN_NAME)) {
                    AbstractClient.printf("%" + deviceColumnLength + "s|", resultSetMetaData.getColumnLabel(i));
                    continue;
                }
                AbstractClient.printf(formatValue, resultSetMetaData.getColumnLabel(i));
            }
        }
        AbstractClient.println();
    }

    static String[] removePasswordArgs(String[] args) {
        int index = -1;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-pw")) continue;
            index = i;
            break;
        }
        if (index >= 0 && (index + 1 >= args.length || index + 1 < args.length && keywordSet.contains(args[index + 1]))) {
            return (String[])ArrayUtils.remove((Object[])args, (int)index);
        }
        return args;
    }

    static String[] processExecuteArgs(String[] args) {
        int index = -1;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-e")) continue;
            index = i;
            break;
        }
        if (index >= 0 && (index + 1 >= args.length || index + 1 < args.length && keywordSet.contains(args[index + 1]))) {
            return (String[])ArrayUtils.remove((Object[])args, (int)index);
        }
        if (index == -1) {
            return args;
        }
        StringBuilder executeCommand = new StringBuilder();
        for (int j = index + 1; j < args.length; ++j) {
            executeCommand.append(args[j]).append(" ");
        }
        executeCommand.deleteCharAt(executeCommand.length() - 1);
        execute = executeCommand.toString();
        hasExecuteSQL = true;
        args = Arrays.copyOfRange(args, 0, index);
        return args;
    }

    static void displayLogo(String version) {
        AbstractClient.println(" _____       _________  ______   ______    \n|_   _|     |  _   _  ||_   _ `.|_   _ \\   \n  | |   .--.|_/ | | \\_|  | | `. \\ | |_) |  \n  | | / .'`\\ \\  | |      | |  | | |  __'.  \n _| |_| \\__. | _| |_    _| |_.' /_| |__) | \n|_____|'.__.' |_____|  |______.'|_______/  version " + version + "\n                                           \n");
    }

    static void echoStarting() {
        AbstractClient.println("---------------------");
        AbstractClient.println("Starting IoTDB Client");
        AbstractClient.println("---------------------");
    }

    static OperationResult handleInputCmd(String cmd, IoTDBConnection connection) {
        String specialCmd = cmd.toLowerCase().trim();
        if (QUIT_COMMAND.equals(specialCmd) || EXIT_COMMAND.equals(specialCmd)) {
            isQuit = true;
            return OperationResult.STOP_OPER;
        }
        if ("help".equals(specialCmd)) {
            AbstractClient.showHelp();
            return OperationResult.CONTINUE_OPER;
        }
        if (specialCmd.startsWith(SET_TIMESTAMP_DISPLAY)) {
            AbstractClient.setTimestampDisplay(specialCmd, cmd);
            return OperationResult.CONTINUE_OPER;
        }
        if (specialCmd.startsWith(SET_TIME_ZONE)) {
            AbstractClient.setTimeZone(specialCmd, cmd, connection);
            return OperationResult.CONTINUE_OPER;
        }
        if (specialCmd.startsWith(SET_FETCH_SIZE)) {
            AbstractClient.setFetchSize(specialCmd, cmd);
            return OperationResult.CONTINUE_OPER;
        }
        if (specialCmd.startsWith(SET_MAX_DISPLAY_NUM)) {
            AbstractClient.setMaxDisplaNum(specialCmd, cmd);
            return OperationResult.CONTINUE_OPER;
        }
        if (specialCmd.startsWith(SHOW_TIMEZONE)) {
            AbstractClient.showTimeZone(connection);
            return OperationResult.CONTINUE_OPER;
        }
        if (specialCmd.startsWith(SHOW_TIMESTAMP_DISPLAY)) {
            AbstractClient.println("Current time format: " + timeFormat);
            return OperationResult.CONTINUE_OPER;
        }
        if (specialCmd.startsWith(SHOW_FETCH_SIZE)) {
            AbstractClient.println("Current fetch size: " + fetchSize);
            return OperationResult.CONTINUE_OPER;
        }
        if (specialCmd.startsWith(IMPORT_CMD)) {
            AbstractClient.importCmd(specialCmd, cmd, connection);
            return OperationResult.CONTINUE_OPER;
        }
        AbstractClient.executeQuery(connection, cmd);
        return OperationResult.NO_OPER;
    }

    private static void showHelp() {
        AbstractClient.println("    <your-sql>\t\t\t execute your sql statment");
        AbstractClient.println(String.format("    %s\t\t show how many timeseries are in iotdb", SHOW_METADATA_COMMAND));
        AbstractClient.println(String.format("    %s=xxx\t eg. long, default, ISO8601, yyyy-MM-dd HH:mm:ss.", SET_TIMESTAMP_DISPLAY));
        AbstractClient.println(String.format("    %s\t show time display type", SHOW_TIMESTAMP_DISPLAY));
        AbstractClient.println(String.format("    %s=xxx\t\t eg. +08:00, Asia/Shanghai.", SET_TIME_ZONE));
        AbstractClient.println(String.format("    %s\t\t show cli time zone", SHOW_TIMEZONE));
        AbstractClient.println(String.format("    %s=xxx\t\t set fetch size when querying data from server.", SET_FETCH_SIZE));
        AbstractClient.println(String.format("    %s\t\t show fetch size", SHOW_FETCH_SIZE));
        AbstractClient.println(String.format("    %s=xxx\t eg. set max lines for cli to ouput, -1 equals to unlimited.", SET_MAX_DISPLAY_NUM));
    }

    private static void setTimestampDisplay(String specialCmd, String cmd) {
        String[] values = specialCmd.split("=");
        if (values.length != 2) {
            AbstractClient.println(String.format("Time display format error, please input like %s=ISO8601", SET_TIMESTAMP_DISPLAY));
            return;
        }
        try {
            AbstractClient.setTimeFormat(cmd.split("=")[1]);
        }
        catch (Exception e) {
            AbstractClient.println(String.format("time display format error, %s", e.getMessage()));
            AbstractClient.handleException(e);
            return;
        }
        AbstractClient.println("Time display type has set to " + cmd.split("=")[1].trim());
    }

    private static void setTimeZone(String specialCmd, String cmd, IoTDBConnection connection) {
        String[] values = specialCmd.split("=");
        if (values.length != 2) {
            AbstractClient.println(String.format("Time zone format error, please input like %s=+08:00", SET_TIME_ZONE));
            return;
        }
        try {
            connection.setTimeZone(cmd.split("=")[1].trim());
        }
        catch (Exception e) {
            AbstractClient.println(String.format("Time zone format error: %s", e.getMessage()));
            AbstractClient.handleException(e);
            return;
        }
        AbstractClient.println("Time zone has set to " + values[1].trim());
    }

    private static void setFetchSize(String specialCmd, String cmd) {
        String[] values = specialCmd.split("=");
        if (values.length != 2) {
            AbstractClient.println(String.format("Fetch size format error, please input like %s=10000", SET_FETCH_SIZE));
            return;
        }
        try {
            AbstractClient.setFetchSize(cmd.split("=")[1]);
        }
        catch (Exception e) {
            AbstractClient.println(String.format("Fetch size format error, %s", e.getMessage()));
            AbstractClient.handleException(e);
            return;
        }
        AbstractClient.println("Fetch size has set to " + values[1].trim());
    }

    private static void setMaxDisplaNum(String specialCmd, String cmd) {
        String[] values = specialCmd.split("=");
        if (values.length != 2) {
            AbstractClient.println(String.format("Max display number format error, please input like %s = 10000", SET_MAX_DISPLAY_NUM));
            return;
        }
        try {
            AbstractClient.setMaxDisplayNumber(cmd.split("=")[1]);
        }
        catch (Exception e) {
            AbstractClient.println(String.format("Max display number format error, %s", e.getMessage()));
            AbstractClient.handleException(e);
            return;
        }
        AbstractClient.println("Max display number has set to " + values[1].trim());
    }

    private static void showTimeZone(IoTDBConnection connection) {
        try {
            AbstractClient.println("Current time zone: " + connection.getTimeZone());
        }
        catch (Exception e) {
            AbstractClient.println("Cannot get time zone from server side because: " + e.getMessage());
            AbstractClient.handleException(e);
        }
    }

    private static void importCmd(String specialCmd, String cmd, IoTDBConnection connection) {
        String[] values = specialCmd.split(" ");
        if (values.length != 2) {
            AbstractClient.println("Please input like: import /User/myfile. Noted that your file path cannot contain any space character)");
            return;
        }
        try {
            AbstractClient.println(cmd.split(" ")[1]);
            ImportCsv.importCsvFromFile(host, port, username, password, cmd.split(" ")[1], connection.getTimeZone());
        }
        catch (SQLException e) {
            AbstractClient.println(String.format("Failed to import from %s because %s", cmd.split(" ")[1], e.getMessage()));
            AbstractClient.handleException(e);
        }
        catch (TException e) {
            AbstractClient.println("Cannot connect to server");
            AbstractClient.handleException((Exception)((Object)e));
        }
    }

    private static void executeQuery(IoTDBConnection connection, String cmd) {
        long startTime = System.currentTimeMillis();
        try (Statement statement = connection.createStatement();){
            ZoneId zoneId = ZoneId.of(connection.getTimeZone());
            statement.setFetchSize(fetchSize);
            boolean hasResultSet = statement.execute(cmd.trim());
            if (hasResultSet) {
                ResultSet resultSet = statement.getResultSet();
                AbstractClient.output(resultSet, printToConsole, zoneId);
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        catch (Exception e) {
            AbstractClient.println("Msg: " + e.getMessage());
            AbstractClient.handleException(e);
        }
        long costTime = System.currentTimeMillis() - startTime;
        AbstractClient.println(String.format("It costs %.3fs", (double)costTime / 1000.0));
    }

    private static void printf(String format, Object ... args) {
        SCREEN_PRINTER.printf(format, args);
    }

    static void print(String msg) {
        SCREEN_PRINTER.print(msg);
    }

    private static void println() {
        SCREEN_PRINTER.println();
    }

    static void println(String msg) {
        SCREEN_PRINTER.println(msg);
    }

    private static void println(Object obj) {
        SCREEN_PRINTER.println(obj);
    }

    static void handleException(Exception e) {
        if (showException) {
            e.printStackTrace(SCREEN_PRINTER);
        }
    }

    static {
        hasExecuteSQL = false;
        printToConsole = true;
        keywordSet = new HashSet<String>();
        properties = null;
        printHeader = false;
        displayCnt = 0;
        SCREEN_PRINTER = new PrintStream(System.out);
        showException = false;
    }

    static enum OperationResult {
        STOP_OPER,
        CONTINUE_OPER,
        NO_OPER;

    }
}

