/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.writelog.recover;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.engine.flush.MemTableFlushTask;
import org.apache.iotdb.db.engine.memtable.PrimitiveMemTable;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.version.VersionController;
import org.apache.iotdb.db.exception.storageGroup.StorageGroupProcessorException;
import org.apache.iotdb.db.writelog.manager.MultiFileLogNodeManager;
import org.apache.iotdb.db.writelog.recover.LogReplayer;
import org.apache.iotdb.tsfile.file.metadata.ChunkGroupMetaData;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetaData;
import org.apache.iotdb.tsfile.file.metadata.TsDeviceMetadata;
import org.apache.iotdb.tsfile.file.metadata.TsDeviceMetadataIndex;
import org.apache.iotdb.tsfile.file.metadata.TsFileMetaData;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.write.schema.Schema;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileRecoverPerformer {
    private static final Logger logger = LoggerFactory.getLogger(TsFileRecoverPerformer.class);
    private String insertFilePath;
    private String logNodePrefix;
    private Schema schema;
    private VersionController versionController;
    private LogReplayer logReplayer;
    private TsFileResource tsFileResource;
    private boolean acceptUnseq;

    public TsFileRecoverPerformer(String logNodePrefix, Schema schema, VersionController versionController, TsFileResource currentTsFileResource, boolean acceptUnseq) {
        this.insertFilePath = currentTsFileResource.getFile().getPath();
        this.logNodePrefix = logNodePrefix;
        this.schema = schema;
        this.versionController = versionController;
        this.tsFileResource = currentTsFileResource;
        this.acceptUnseq = acceptUnseq;
    }

    public void recover() throws StorageGroupProcessorException {
        RestorableTsFileIOWriter restorableTsFileIOWriter;
        PrimitiveMemTable recoverMemTable = new PrimitiveMemTable();
        this.logReplayer = new LogReplayer(this.logNodePrefix, this.insertFilePath, this.tsFileResource.getModFile(), this.versionController, this.tsFileResource, this.schema, recoverMemTable, this.acceptUnseq);
        File insertFile = FSFactoryProducer.getFSFactory().getFile(this.insertFilePath);
        if (!insertFile.exists()) {
            logger.error("TsFile {} is missing, will skip its recovery.", (Object)this.insertFilePath);
            return;
        }
        try {
            restorableTsFileIOWriter = new RestorableTsFileIOWriter(insertFile);
        }
        catch (IOException e) {
            throw new StorageGroupProcessorException(e);
        }
        if (!restorableTsFileIOWriter.hasCrashed() && !restorableTsFileIOWriter.canWrite()) {
            try {
                if (this.tsFileResource.fileExists()) {
                    this.recoverResourceFromFile();
                } else {
                    try (TsFileSequenceReader reader = new TsFileSequenceReader(this.tsFileResource.getFile().getAbsolutePath());){
                        TsFileMetaData metaData = reader.readFileMetadata();
                        ArrayList deviceMetadataIndexList = new ArrayList(metaData.getDeviceMap().values());
                        for (TsDeviceMetadataIndex index : deviceMetadataIndexList) {
                            TsDeviceMetadata deviceMetadata = reader.readTsDeviceMetaData(index);
                            List chunkGroupMetaDataList = deviceMetadata.getChunkGroupMetaDataList();
                            for (ChunkGroupMetaData chunkGroupMetaData : chunkGroupMetaDataList) {
                                for (ChunkMetaData chunkMetaData : chunkGroupMetaData.getChunkMetaDataList()) {
                                    this.tsFileResource.updateStartTime(chunkGroupMetaData.getDeviceID(), chunkMetaData.getStartTime());
                                    this.tsFileResource.updateEndTime(chunkGroupMetaData.getDeviceID(), chunkMetaData.getEndTime());
                                }
                            }
                        }
                    }
                    this.tsFileResource.serialize();
                }
                return;
            }
            catch (IOException e) {
                throw new StorageGroupProcessorException("recover the resource file failed: " + this.insertFilePath + ".resource" + e);
            }
        }
        this.recoverResourceFromWriter(restorableTsFileIOWriter);
        this.redoLogs(restorableTsFileIOWriter);
        try {
            MultiFileLogNodeManager.getInstance().deleteNode(this.logNodePrefix + SystemFileFactory.INSTANCE.getFile(this.insertFilePath).getName());
        }
        catch (IOException e) {
            throw new StorageGroupProcessorException(e);
        }
    }

    private void recoverResourceFromFile() throws IOException {
        try {
            this.tsFileResource.deSerialize();
        }
        catch (IOException e) {
            logger.warn("Cannot deserialize TsFileResource {}, construct it using TsFileSequenceReader", (Object)this.tsFileResource.getFile(), (Object)e);
            this.recoverResourceFromReader();
        }
    }

    private void recoverResourceFromReader() throws IOException {
        try (TsFileSequenceReader reader = new TsFileSequenceReader(this.tsFileResource.getFile().getAbsolutePath(), false);){
            TsFileMetaData metaData = reader.readFileMetadata();
            ArrayList deviceMetadataIndexList = new ArrayList(metaData.getDeviceMap().values());
            for (TsDeviceMetadataIndex index : deviceMetadataIndexList) {
                TsDeviceMetadata deviceMetadata = reader.readTsDeviceMetaData(index);
                for (ChunkGroupMetaData chunkGroupMetaData : deviceMetadata.getChunkGroupMetaDataList()) {
                    for (ChunkMetaData chunkMetaData : chunkGroupMetaData.getChunkMetaDataList()) {
                        this.tsFileResource.updateStartTime(chunkGroupMetaData.getDeviceID(), chunkMetaData.getStartTime());
                        this.tsFileResource.updateEndTime(chunkGroupMetaData.getDeviceID(), chunkMetaData.getEndTime());
                    }
                }
            }
        }
        this.tsFileResource.serialize();
    }

    private void recoverResourceFromWriter(RestorableTsFileIOWriter restorableTsFileIOWriter) {
        for (ChunkGroupMetaData chunkGroupMetaData : restorableTsFileIOWriter.getChunkGroupMetaDatas()) {
            for (ChunkMetaData chunkMetaData : chunkGroupMetaData.getChunkMetaDataList()) {
                this.tsFileResource.updateStartTime(chunkGroupMetaData.getDeviceID(), chunkMetaData.getStartTime());
                this.tsFileResource.updateEndTime(chunkGroupMetaData.getDeviceID(), chunkMetaData.getEndTime());
            }
        }
    }

    private void redoLogs(RestorableTsFileIOWriter restorableTsFileIOWriter) throws StorageGroupProcessorException {
        PrimitiveMemTable recoverMemTable = new PrimitiveMemTable();
        this.logReplayer = new LogReplayer(this.logNodePrefix, this.insertFilePath, this.tsFileResource.getModFile(), this.versionController, this.tsFileResource, this.schema, recoverMemTable, this.acceptUnseq);
        this.logReplayer.replayLogs();
        try {
            if (!recoverMemTable.isEmpty()) {
                MemTableFlushTask tableFlushTask = new MemTableFlushTask(recoverMemTable, this.schema, restorableTsFileIOWriter, this.tsFileResource.getFile().getParentFile().getName());
                tableFlushTask.syncFlushMemTable();
            }
            restorableTsFileIOWriter.endFile(this.schema);
            this.tsFileResource.serialize();
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw new StorageGroupProcessorException(e);
        }
    }
}

