/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.receiver.load;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.SyncDeviceOwnerConflictException;
import org.apache.iotdb.db.exception.TsFileProcessorException;
import org.apache.iotdb.db.sync.receiver.load.FileLoaderManager;
import org.apache.iotdb.db.sync.receiver.load.IFileLoader;
import org.apache.iotdb.db.sync.receiver.load.ILoadLogger;
import org.apache.iotdb.db.sync.receiver.load.LoadLogger;
import org.apache.iotdb.db.sync.receiver.load.LoadType;
import org.apache.iotdb.tsfile.file.metadata.ChunkGroupMetaData;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetaData;
import org.apache.iotdb.tsfile.file.metadata.TsDeviceMetadata;
import org.apache.iotdb.tsfile.file.metadata.TsDeviceMetadataIndex;
import org.apache.iotdb.tsfile.file.metadata.TsFileMetaData;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLoader
implements IFileLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileLoader.class);
    public static final int WAIT_TIME = 100;
    private String syncFolderPath;
    private String senderName;
    private BlockingQueue<LoadTask> queue = new LinkedBlockingQueue<LoadTask>();
    private ILoadLogger loadLog;
    private LoadType curType = LoadType.NONE;
    private volatile boolean endSync = false;
    private Runnable loadTaskRunner = () -> {
        block4: while (true) {
            try {
                while (true) {
                    if (this.queue.isEmpty() && this.endSync) {
                        this.cleanUp();
                        break block4;
                    }
                    LoadTask loadTask = this.queue.poll(100L, TimeUnit.MILLISECONDS);
                    if (loadTask == null) continue;
                    try {
                        this.handleLoadTask(loadTask);
                        continue block4;
                    }
                    catch (Exception e) {
                        LOGGER.error("Can not load task {}", (Object)loadTask, (Object)e);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("Can not handle load task", (Throwable)e);
                break;
            }
        }
    };

    private FileLoader(String senderName, String syncFolderPath) throws IOException {
        this.senderName = senderName;
        this.syncFolderPath = syncFolderPath;
        this.loadLog = new LoadLogger(new File(syncFolderPath, "load.log"));
    }

    public static FileLoader createFileLoader(String senderName, String syncFolderPath) throws IOException {
        FileLoader fileLoader = new FileLoader(senderName, syncFolderPath);
        FileLoaderManager.getInstance().addFileLoader(senderName, fileLoader);
        FileLoaderManager.getInstance().addLoadTaskRunner(fileLoader.loadTaskRunner);
        return fileLoader;
    }

    public static FileLoader createFileLoader(File syncFolder) throws IOException {
        return FileLoader.createFileLoader(syncFolder.getName(), syncFolder.getAbsolutePath());
    }

    @Override
    public void addDeletedFileName(File deletedFile) {
        this.queue.add(new LoadTask(deletedFile, LoadType.DELETE));
    }

    @Override
    public void addTsfile(File tsfile) {
        this.queue.add(new LoadTask(tsfile, LoadType.ADD));
    }

    @Override
    public void endSync() {
        if (!this.endSync && FileLoaderManager.getInstance().containsFileLoader(this.senderName)) {
            this.endSync = true;
        }
    }

    @Override
    public void handleLoadTask(LoadTask task) throws IOException {
        switch (task.type) {
            case ADD: {
                this.loadNewTsfile(task.file);
                break;
            }
            case DELETE: {
                this.loadDeletedFile(task.file);
                break;
            }
            default: {
                LOGGER.error("Wrong load task type {}", (Object)task.type);
            }
        }
    }

    private void loadNewTsfile(File newTsFile) throws IOException {
        if (this.curType != LoadType.ADD) {
            this.loadLog.startLoadTsFiles();
            this.curType = LoadType.ADD;
        }
        if (!newTsFile.exists()) {
            LOGGER.info("Tsfile {} doesn't exist.", (Object)newTsFile.getAbsolutePath());
            return;
        }
        TsFileResource tsFileResource = new TsFileResource(newTsFile);
        this.checkTsFileResource(tsFileResource);
        try {
            FileLoaderManager.getInstance().checkAndUpdateDeviceOwner(tsFileResource);
            StorageEngine.getInstance().loadNewTsFile(tsFileResource);
        }
        catch (SyncDeviceOwnerConflictException e) {
            LOGGER.error("Device owner has conflicts, so skip the loading file", (Throwable)e);
        }
        catch (StorageEngineException | TsFileProcessorException e) {
            LOGGER.error("Can not load new tsfile {}", (Object)newTsFile.getAbsolutePath(), (Object)e);
            throw new IOException(e);
        }
        this.loadLog.finishLoadTsfile(newTsFile);
    }

    private void checkTsFileResource(TsFileResource tsFileResource) throws IOException {
        if (!tsFileResource.fileExists()) {
            try (TsFileSequenceReader reader = new TsFileSequenceReader(tsFileResource.getFile().getAbsolutePath());){
                TsFileMetaData metaData = reader.readFileMetadata();
                for (TsDeviceMetadataIndex index : metaData.getDeviceMap().values()) {
                    TsDeviceMetadata deviceMetadata = reader.readTsDeviceMetaData(index);
                    List chunkGroupMetaDataList = deviceMetadata.getChunkGroupMetaDataList();
                    for (ChunkGroupMetaData chunkGroupMetaData : chunkGroupMetaDataList) {
                        for (ChunkMetaData chunkMetaData : chunkGroupMetaData.getChunkMetaDataList()) {
                            tsFileResource.updateStartTime(chunkGroupMetaData.getDeviceID(), chunkMetaData.getStartTime());
                            tsFileResource.updateEndTime(chunkGroupMetaData.getDeviceID(), chunkMetaData.getEndTime());
                        }
                    }
                }
            }
            tsFileResource.serialize();
        } else {
            tsFileResource.deSerialize();
        }
    }

    private void loadDeletedFile(File deletedTsFile) throws IOException {
        if (this.curType != LoadType.DELETE) {
            this.loadLog.startLoadDeletedFiles();
            this.curType = LoadType.DELETE;
        }
        try {
            StorageEngine.getInstance().deleteTsfile(deletedTsFile);
        }
        catch (StorageEngineException e) {
            LOGGER.error("Can not load deleted tsfile {}", (Object)deletedTsFile.getAbsolutePath(), (Object)e);
            throw new IOException(e);
        }
        this.loadLog.finishLoadDeletedFile(deletedTsFile);
    }

    @Override
    public void cleanUp() {
        try {
            this.loadLog.close();
            new File(this.syncFolderPath, "sync.log").delete();
            new File(this.syncFolderPath, "load.log").delete();
            FileUtils.deleteDirectory((File)new File(this.syncFolderPath, "data"));
            FileLoaderManager.getInstance().removeFileLoader(this.senderName);
            LOGGER.info("Sync loading process for {} has finished.", (Object)this.senderName);
        }
        catch (IOException e) {
            LOGGER.error("Can not clean up sync resource.", (Throwable)e);
        }
    }

    @Override
    public void setCurType(LoadType curType) {
        this.curType = curType;
    }

    class LoadTask {
        private File file;
        private LoadType type;

        LoadTask(File file, LoadType type) {
            this.file = file;
            this.type = type;
        }

        public String toString() {
            return "LoadTask{file=" + this.file.getAbsolutePath() + ", type=" + (Object)((Object)this.type) + '}';
        }
    }
}

