/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.receiver;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.iotdb.db.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.concurrent.ThreadName;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StartupException;
import org.apache.iotdb.db.service.IService;
import org.apache.iotdb.db.service.ServiceType;
import org.apache.iotdb.db.sync.receiver.load.FileLoaderManager;
import org.apache.iotdb.db.sync.receiver.recover.SyncReceiverLogAnalyzer;
import org.apache.iotdb.db.sync.receiver.transfer.SyncServiceImpl;
import org.apache.iotdb.service.sync.thrift.SyncService;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncServerManager
implements IService {
    private static final Logger logger = LoggerFactory.getLogger(SyncServerManager.class);
    private IoTDBConfig conf = IoTDBDescriptor.getInstance().getConfig();
    private Thread syncServerThread;

    private SyncServerManager() {
    }

    public static SyncServerManager getInstance() {
        return ServerManagerHolder.INSTANCE;
    }

    @Override
    public void start() throws StartupException {
        if (!this.conf.isSyncEnable()) {
            return;
        }
        FileLoaderManager.getInstance().start();
        try {
            SyncReceiverLogAnalyzer.getInstance().recoverAll();
        }
        catch (IOException e) {
            logger.error("Can not recover receiver sync state", (Throwable)e);
        }
        if (this.conf.getIpWhiteList() == null) {
            logger.error("Sync server failed to start because IP white list is null, please set IP white list.");
            return;
        }
        this.conf.setIpWhiteList(this.conf.getIpWhiteList().replaceAll(" ", ""));
        this.syncServerThread = new SyncServiceThread();
        this.syncServerThread.setName(ThreadName.SYNC_SERVER.getName());
        this.syncServerThread.start();
        logger.info("Sync server has started.");
    }

    @Override
    public void stop() {
        if (this.conf.isSyncEnable()) {
            FileLoaderManager.getInstance().stop();
            ((SyncServiceThread)this.syncServerThread).close();
        }
    }

    @Override
    public ServiceType getID() {
        return ServiceType.SYNC_SERVICE;
    }

    private class SyncServiceThread
    extends Thread {
        private TServerSocket serverTransport;
        private TServer poolServer;
        private TProtocolFactory protocolFactory;
        private SyncService.Processor<SyncService.Iface> processor = new SyncService.Processor((SyncService.Iface)new SyncServiceImpl());
        private TThreadPoolServer.Args poolArgs;

        @Override
        public void run() {
            try {
                this.serverTransport = new TServerSocket(new InetSocketAddress(SyncServerManager.this.conf.getRpcAddress(), SyncServerManager.this.conf.getSyncServerPort()));
                this.protocolFactory = SyncServerManager.this.conf.isRpcThriftCompressionEnable() ? new TCompactProtocol.Factory() : new TBinaryProtocol.Factory();
                this.processor = new SyncService.Processor((SyncService.Iface)new SyncServiceImpl());
                this.poolArgs = new TThreadPoolServer.Args((TServerTransport)this.serverTransport);
                this.poolArgs.executorService = IoTDBThreadPoolFactory.createThriftRpcClientThreadPool(this.poolArgs, ThreadName.SYNC_CLIENT.getName());
                this.poolArgs.protocolFactory(this.protocolFactory);
                this.poolArgs.processor(this.processor);
                this.poolServer = new TThreadPoolServer(this.poolArgs);
                this.poolServer.serve();
            }
            catch (TTransportException e) {
                logger.error("{}: failed to start {}, because ", new Object[]{"IoTDB", SyncServerManager.this.getID().getName(), e});
            }
            catch (Exception e) {
                logger.error("{}: {} exit, because ", new Object[]{"IoTDB", SyncServerManager.this.getID().getName(), e});
            }
            finally {
                this.close();
                logger.info("{}: close TThreadPoolServer and TServerSocket for {}", (Object)"IoTDB", (Object)SyncServerManager.this.getID().getName());
            }
        }

        private synchronized void close() {
            if (this.poolServer != null) {
                this.poolServer.stop();
                this.poolServer = null;
            }
            if (this.serverTransport != null) {
                this.serverTransport.close();
                this.serverTransport = null;
            }
        }
    }

    private static class ServerManagerHolder {
        private static final SyncServerManager INSTANCE = new SyncServerManager();

        private ServerManagerHolder() {
        }
    }
}

