/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.conf;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class SyncSenderConfig {
    private String serverIp = "127.0.0.1";
    private int serverPort = 5555;
    private int syncPeriodInSecond = 600;
    private String senderFolderPath;
    private String lockFilePath;
    private String uuidPath;
    private String lastFileInfoPath;
    private String snapshotPath;
    private int maxNumOfSyncFileRetry = 5;
    private List<String> storageGroupList = new ArrayList<String>();

    public void update(String dataDirectory) {
        this.senderFolderPath = dataDirectory + File.separatorChar + "sync-sender" + File.separatorChar + this.getSyncReceiverName();
        this.lockFilePath = this.senderFolderPath + File.separatorChar + "sync_lock";
        this.uuidPath = this.senderFolderPath + File.separatorChar + "uuid.txt";
        this.lastFileInfoPath = this.senderFolderPath + File.separatorChar + "last_local_files.txt";
        this.snapshotPath = this.senderFolderPath + File.separatorChar + "snapshot";
        if (!new File(this.snapshotPath).exists()) {
            new File(this.snapshotPath).mkdirs();
        }
    }

    public String getServerIp() {
        return this.serverIp;
    }

    public void setServerIp(String serverIp) {
        this.serverIp = serverIp;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public int getSyncPeriodInSecond() {
        return this.syncPeriodInSecond;
    }

    public void setSyncPeriodInSecond(int syncPeriodInSecond) {
        this.syncPeriodInSecond = syncPeriodInSecond;
    }

    public String getSenderFolderPath() {
        return this.senderFolderPath;
    }

    public void setSenderFolderPath(String senderFolderPath) {
        this.senderFolderPath = senderFolderPath;
    }

    public String getLockFilePath() {
        return this.lockFilePath;
    }

    public void setLockFilePath(String lockFilePath) {
        this.lockFilePath = lockFilePath;
    }

    public String getLastFileInfoPath() {
        return this.lastFileInfoPath;
    }

    public void setLastFileInfoPath(String lastFileInfoPath) {
        this.lastFileInfoPath = lastFileInfoPath;
    }

    public String getSnapshotPath() {
        return this.snapshotPath;
    }

    public void setSnapshotPath(String snapshotPath) {
        this.snapshotPath = snapshotPath;
    }

    public String getUuidPath() {
        return this.uuidPath;
    }

    public String getSyncReceiverName() {
        return this.serverIp + "_" + this.serverPort;
    }

    public List<String> getStorageGroupList() {
        return new ArrayList<String>(this.storageGroupList);
    }

    public void setStorageGroupList(List<String> storageGroupList) {
        this.storageGroupList = storageGroupList;
    }

    public int getMaxNumOfSyncFileRetry() {
        return this.maxNumOfSyncFileRetry;
    }

    public void setMaxNumOfSyncFileRetry(int maxNumOfSyncFileRetry) {
        this.maxNumOfSyncFileRetry = maxNumOfSyncFileRetry;
    }
}

