/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.universal;

import java.io.IOException;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.iotdb.db.query.reader.IPointReader;
import org.apache.iotdb.db.utils.TimeValuePair;

public class PriorityMergeReader
implements IPointReader {
    PriorityQueue<Element> heap = new PriorityQueue((o1, o2) -> {
        int timeCompare = Long.compare(o1.timeValuePair.getTimestamp(), o2.timeValuePair.getTimestamp());
        return timeCompare != 0 ? timeCompare : Integer.compare(o2.priority, o1.priority);
    });

    public PriorityMergeReader() {
    }

    public PriorityMergeReader(List<IPointReader> prioritySeriesReaders, int startPriority) throws IOException {
        for (IPointReader reader : prioritySeriesReaders) {
            this.addReaderWithPriority(reader, startPriority++);
        }
    }

    public void addReaderWithPriority(IPointReader reader, int priority) throws IOException {
        if (reader.hasNext()) {
            this.heap.add(new Element(reader, reader.next(), priority));
        } else {
            reader.close();
        }
    }

    @Override
    public boolean hasNext() {
        return !this.heap.isEmpty();
    }

    @Override
    public TimeValuePair next() throws IOException {
        Element top = this.heap.poll();
        TimeValuePair ret = top.timeValuePair;
        TimeValuePair topNext = null;
        if (top.hasNext()) {
            top.next();
            topNext = top.currPair();
        }
        long topNextTime = topNext == null ? Long.MAX_VALUE : topNext.getTimestamp();
        this.updateHeap(ret.getTimestamp(), topNextTime);
        if (topNext != null) {
            top.timeValuePair = topNext;
            this.heap.add(top);
        }
        return ret;
    }

    @Override
    public TimeValuePair current() throws IOException {
        return this.heap.peek().timeValuePair;
    }

    private void updateHeap(long topTime, long topNextTime) throws IOException {
        while (!this.heap.isEmpty() && this.heap.peek().currTime() == topTime) {
            Element e = this.heap.poll();
            if (!e.hasNext()) {
                e.reader.close();
                continue;
            }
            e.next();
            if (e.currTime() == topNextTime) {
                if (e.hasNext()) {
                    e.next();
                    this.heap.add(e);
                    continue;
                }
                e.close();
                continue;
            }
            this.heap.add(e);
        }
    }

    @Override
    public void close() throws IOException {
        while (!this.heap.isEmpty()) {
            Element e = this.heap.poll();
            e.close();
        }
    }

    class Element {
        IPointReader reader;
        TimeValuePair timeValuePair;
        int priority;

        Element(IPointReader reader, TimeValuePair timeValuePair, int priority) {
            this.reader = reader;
            this.timeValuePair = timeValuePair;
            this.priority = priority;
        }

        long currTime() {
            return this.timeValuePair.getTimestamp();
        }

        TimeValuePair currPair() {
            return this.timeValuePair;
        }

        boolean hasNext() throws IOException {
            return this.reader.hasNext();
        }

        void next() throws IOException {
            this.timeValuePair = this.reader.next();
        }

        void close() throws IOException {
            this.reader.close();
        }
    }
}

