/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.fileRelated;

import java.io.IOException;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.db.query.reader.IReaderByTimestamp;
import org.apache.iotdb.db.query.reader.chunkRelated.MemChunkReaderByTimestamp;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.controller.ChunkLoaderImpl;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;
import org.apache.iotdb.tsfile.read.reader.series.FileSeriesReaderByTimestamp;

public class UnSealedTsFileReaderByTimestamp
implements IReaderByTimestamp {
    private FileSeriesReaderByTimestamp unSealedTsFileDiskReaderByTs;
    private IReaderByTimestamp unSealedTsFileMemReaderByTs;
    private boolean unSealedTsFileDiskReaderEnded;

    public UnSealedTsFileReaderByTimestamp(TsFileResource unsealedTsFile) throws IOException {
        this.unSealedTsFileMemReaderByTs = new MemChunkReaderByTimestamp(unsealedTsFile.getReadOnlyMemChunk());
        TsFileSequenceReader unClosedTsFileReader = FileReaderManager.getInstance().get(unsealedTsFile, false);
        ChunkLoaderImpl chunkLoader = new ChunkLoaderImpl(unClosedTsFileReader);
        this.unSealedTsFileDiskReaderByTs = new FileSeriesReaderByTimestamp((IChunkLoader)chunkLoader, unsealedTsFile.getChunkMetaDataList());
        this.unSealedTsFileDiskReaderEnded = false;
    }

    @Override
    public Object getValueInTimestamp(long timestamp) throws IOException {
        if (!this.unSealedTsFileDiskReaderEnded) {
            Object value = this.unSealedTsFileDiskReaderByTs.getValueInTimestamp(timestamp);
            if (value != null || this.unSealedTsFileDiskReaderByTs.hasNext()) {
                return value;
            }
            this.unSealedTsFileDiskReaderEnded = true;
        }
        return this.unSealedTsFileMemReaderByTs.getValueInTimestamp(timestamp);
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.unSealedTsFileDiskReaderEnded) {
            return this.unSealedTsFileMemReaderByTs.hasNext();
        }
        return this.unSealedTsFileDiskReaderByTs.hasNext() || this.unSealedTsFileMemReaderByTs.hasNext();
    }
}

