/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.chunkRelated;

import java.util.Iterator;
import org.apache.iotdb.db.engine.querycontext.ReadOnlyMemChunk;
import org.apache.iotdb.db.query.reader.IAggregateReader;
import org.apache.iotdb.db.query.reader.IPointReader;
import org.apache.iotdb.db.utils.TimeValuePair;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;

public class MemChunkReader
implements IPointReader,
IAggregateReader {
    private Iterator<TimeValuePair> timeValuePairIterator;
    private Filter filter;
    private boolean hasCachedTimeValuePair;
    private TimeValuePair cachedTimeValuePair;
    private TSDataType dataType;

    public MemChunkReader(ReadOnlyMemChunk readableChunk, Filter filter) {
        this.timeValuePairIterator = readableChunk.getIterator();
        this.filter = filter;
        this.dataType = readableChunk.getDataType();
    }

    @Override
    public boolean hasNext() {
        if (this.hasCachedTimeValuePair) {
            return true;
        }
        while (this.timeValuePairIterator.hasNext()) {
            TimeValuePair timeValuePair = this.timeValuePairIterator.next();
            if (this.filter != null && !this.filter.satisfy(timeValuePair.getTimestamp(), timeValuePair.getValue().getValue())) continue;
            this.hasCachedTimeValuePair = true;
            this.cachedTimeValuePair = timeValuePair;
            break;
        }
        return this.hasCachedTimeValuePair;
    }

    @Override
    public TimeValuePair next() {
        if (this.hasCachedTimeValuePair) {
            this.hasCachedTimeValuePair = false;
            return this.cachedTimeValuePair;
        }
        return this.timeValuePairIterator.next();
    }

    @Override
    public TimeValuePair current() {
        if (!this.hasCachedTimeValuePair) {
            this.cachedTimeValuePair = this.timeValuePairIterator.next();
            this.hasCachedTimeValuePair = true;
        }
        return this.cachedTimeValuePair;
    }

    @Override
    public BatchData nextBatch() {
        BatchData batchData = new BatchData(this.dataType, true);
        if (this.hasCachedTimeValuePair) {
            this.hasCachedTimeValuePair = false;
            batchData.putTime(this.cachedTimeValuePair.getTimestamp());
            batchData.putAnObject(this.cachedTimeValuePair.getValue().getValue());
        }
        while (this.timeValuePairIterator.hasNext()) {
            TimeValuePair timeValuePair = this.timeValuePairIterator.next();
            if (this.filter != null && !this.filter.satisfy(timeValuePair.getTimestamp(), timeValuePair.getValue().getValue())) continue;
            batchData.putTime(timeValuePair.getTimestamp());
            batchData.putAnObject(timeValuePair.getValue().getValue());
        }
        return batchData;
    }

    @Override
    public void close() {
    }

    @Override
    public PageHeader nextPageHeader() {
        return null;
    }

    @Override
    public void skipPageData() {
        this.nextBatch();
    }
}

