/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.chunkRelated;

import java.io.IOException;
import org.apache.iotdb.db.query.reader.IPointReader;
import org.apache.iotdb.db.utils.TimeValuePair;
import org.apache.iotdb.db.utils.TimeValuePairUtils;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.reader.chunk.ChunkReader;

public class CachedDiskChunkReader
implements IPointReader {
    private ChunkReader chunkReader;
    private BatchData data;
    private TimeValuePair prev;
    private TimeValuePair current;

    public CachedDiskChunkReader(ChunkReader chunkReader) {
        this.chunkReader = chunkReader;
        this.prev = TimeValuePairUtils.getEmptyTimeValuePair(chunkReader.getChunkHeader().getDataType());
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.data != null && this.data.hasNext()) {
            return true;
        }
        while (this.chunkReader.hasNextBatch()) {
            this.data = this.chunkReader.nextBatch();
            if (!this.data.hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public TimeValuePair next() throws IOException {
        TimeValuePairUtils.setCurrentTimeValuePair(this.data, this.prev);
        this.data.next();
        if (this.data.hasNext()) {
            TimeValuePairUtils.setCurrentTimeValuePair(this.data, this.current());
        } else {
            while (this.chunkReader.hasNextBatch()) {
                this.data = this.chunkReader.nextBatch();
                if (!this.data.hasNext()) continue;
                TimeValuePairUtils.setCurrentTimeValuePair(this.data, this.current());
                break;
            }
        }
        return this.prev;
    }

    @Override
    public TimeValuePair current() {
        if (this.current == null) {
            this.current = TimeValuePairUtils.getEmptyTimeValuePair(this.chunkReader.getChunkHeader().getDataType());
            TimeValuePairUtils.setCurrentTimeValuePair(this.data, this.current);
        }
        return this.current;
    }

    @Override
    public void close() {
        this.chunkReader.close();
    }
}

