/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.fill;

import java.io.IOException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.UnSupportedFillTypeException;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.reader.IPointReader;
import org.apache.iotdb.db.query.reader.seriesRelated.SeriesReaderWithoutValueFilter;
import org.apache.iotdb.db.utils.TimeValuePair;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.filter.TimeFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;

public abstract class IFill {
    long queryTime;
    TSDataType dataType;
    IPointReader allDataReader;

    public IFill(TSDataType dataType, long queryTime) {
        this.dataType = dataType;
        this.queryTime = queryTime;
    }

    public IFill() {
    }

    public abstract IFill copy(Path var1);

    public abstract void constructReaders(Path var1, QueryContext var2) throws IOException, StorageEngineException;

    void constructReaders(Path path, QueryContext context, long beforeRange) throws IOException, StorageEngineException {
        Filter timeFilter = this.constructFilter(beforeRange);
        this.allDataReader = new SeriesReaderWithoutValueFilter(path, timeFilter, context);
    }

    public abstract IPointReader getFillResult() throws IOException, UnSupportedFillTypeException;

    public TSDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(TSDataType dataType) {
        this.dataType = dataType;
    }

    public void setQueryTime(long queryTime) {
        this.queryTime = queryTime;
    }

    private Filter constructFilter(long beforeRange) {
        if (beforeRange == -1L) {
            return null;
        }
        return TimeFilter.gtEq((long)(this.queryTime - beforeRange));
    }

    class TimeValuePairPointReader
    implements IPointReader {
        private boolean isUsed;
        private TimeValuePair pair;

        public TimeValuePairPointReader(TimeValuePair pair) {
            this.pair = pair;
            this.isUsed = pair == null;
        }

        @Override
        public boolean hasNext() {
            return !this.isUsed;
        }

        @Override
        public TimeValuePair next() {
            this.isUsed = true;
            return this.pair;
        }

        @Override
        public TimeValuePair current() {
            return this.pair;
        }

        @Override
        public void close() {
        }
    }
}

