/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.externalsort;

import java.io.IOException;
import java.util.List;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.externalsort.serialize.impl.FixLengthIExternalSortFileDeserializer;
import org.apache.iotdb.db.query.externalsort.serialize.impl.FixLengthTimeValuePairSerializer;
import org.apache.iotdb.db.query.reader.IPointReader;
import org.apache.iotdb.db.query.reader.universal.PriorityMergeReader;

public class LineMerger {
    private String tmpFilePath;
    private long queryId;

    public LineMerger(long queryId, String tmpFilePath) {
        this.tmpFilePath = tmpFilePath;
        this.queryId = queryId;
    }

    public IPointReader merge(List<IPointReader> prioritySeriesReaders) throws IOException {
        FixLengthTimeValuePairSerializer serializer = new FixLengthTimeValuePairSerializer(this.tmpFilePath);
        PriorityMergeReader reader = new PriorityMergeReader(prioritySeriesReaders, 1);
        while (reader.hasNext()) {
            serializer.write(reader.next());
        }
        reader.close();
        serializer.close();
        FixLengthIExternalSortFileDeserializer deserializer = new FixLengthIExternalSortFileDeserializer(this.tmpFilePath);
        QueryResourceManager.getInstance().registerTempExternalSortFile(this.queryId, deserializer);
        return deserializer;
    }
}

