/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.executor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.dataset.EngineDataSetWithoutValueFilter;
import org.apache.iotdb.db.query.fill.IFill;
import org.apache.iotdb.db.query.fill.PreviousFill;
import org.apache.iotdb.db.query.reader.IPointReader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;

public class FillEngineExecutor {
    private long jobId;
    private List<Path> selectedSeries;
    private long queryTime;
    private Map<TSDataType, IFill> typeIFillMap;

    public FillEngineExecutor(long jobId, List<Path> selectedSeries, long queryTime, Map<TSDataType, IFill> typeIFillMap) {
        this.jobId = jobId;
        this.selectedSeries = selectedSeries;
        this.queryTime = queryTime;
        this.typeIFillMap = typeIFillMap;
    }

    public QueryDataSet execute(QueryContext context) throws StorageEngineException, QueryProcessException, IOException {
        ArrayList<IFill> fillList = new ArrayList<IFill>();
        ArrayList<TSDataType> dataTypeList = new ArrayList<TSDataType>();
        for (Path path : this.selectedSeries) {
            TSDataType dataType = MManager.getInstance().getSeriesType(path.getFullPath());
            dataTypeList.add(dataType);
            IFill fill = !this.typeIFillMap.containsKey(dataType) ? new PreviousFill(dataType, this.queryTime, 0L) : this.typeIFillMap.get(dataType).copy(path);
            fill.setDataType(dataType);
            fill.setQueryTime(this.queryTime);
            fill.constructReaders(path, context);
            fillList.add(fill);
        }
        ArrayList<IPointReader> readers = new ArrayList<IPointReader>();
        for (IFill fill : fillList) {
            readers.add(fill.getFillResult());
        }
        return new EngineDataSetWithoutValueFilter(this.selectedSeries, dataTypeList, readers);
    }
}

