/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset;

import java.io.IOException;
import java.util.List;
import java.util.TreeSet;
import org.apache.iotdb.db.query.reader.IPointReader;
import org.apache.iotdb.db.utils.TimeValuePair;
import org.apache.iotdb.db.utils.TsPrimitiveType;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;

public class EngineDataSetWithoutValueFilter
extends QueryDataSet {
    private List<IPointReader> seriesReaderWithoutValueFilterList;
    private TimeValuePair[] cacheTimeValueList;
    private TreeSet<Long> timeHeap;

    public EngineDataSetWithoutValueFilter(List<Path> paths, List<TSDataType> dataTypes, List<IPointReader> readers) throws IOException {
        super(paths, dataTypes);
        this.seriesReaderWithoutValueFilterList = readers;
        this.initHeap();
    }

    private void initHeap() throws IOException {
        this.timeHeap = new TreeSet();
        this.cacheTimeValueList = new TimeValuePair[this.seriesReaderWithoutValueFilterList.size()];
        for (int i = 0; i < this.seriesReaderWithoutValueFilterList.size(); ++i) {
            TimeValuePair timeValuePair;
            IPointReader reader = this.seriesReaderWithoutValueFilterList.get(i);
            if (!reader.hasNext()) continue;
            this.cacheTimeValueList[i] = timeValuePair = reader.next();
            this.timeHeapPut(timeValuePair.getTimestamp());
        }
    }

    public boolean hasNext() {
        return !this.timeHeap.isEmpty();
    }

    public RowRecord next() throws IOException {
        long minTime = this.timeHeapGet();
        RowRecord record = new RowRecord(minTime);
        for (int i = 0; i < this.seriesReaderWithoutValueFilterList.size(); ++i) {
            IPointReader reader = this.seriesReaderWithoutValueFilterList.get(i);
            if (this.cacheTimeValueList[i] == null) {
                record.addField(new Field(null));
                continue;
            }
            if (this.cacheTimeValueList[i].getTimestamp() == minTime) {
                record.addField(this.getField(this.cacheTimeValueList[i].getValue(), (TSDataType)this.dataTypes.get(i)));
                if (!this.seriesReaderWithoutValueFilterList.get(i).hasNext()) continue;
                this.cacheTimeValueList[i] = reader.next();
                this.timeHeapPut(this.cacheTimeValueList[i].getTimestamp());
                continue;
            }
            record.addField(new Field(null));
        }
        return record;
    }

    private Field getField(TsPrimitiveType tsPrimitiveType, TSDataType dataType) {
        if (tsPrimitiveType == null) {
            return new Field(null);
        }
        Field field = new Field(dataType);
        switch (dataType) {
            case INT32: {
                field.setIntV(tsPrimitiveType.getInt());
                break;
            }
            case INT64: {
                field.setLongV(tsPrimitiveType.getLong());
                break;
            }
            case FLOAT: {
                field.setFloatV(tsPrimitiveType.getFloat());
                break;
            }
            case DOUBLE: {
                field.setDoubleV(tsPrimitiveType.getDouble());
                break;
            }
            case BOOLEAN: {
                field.setBoolV(tsPrimitiveType.getBoolean());
                break;
            }
            case TEXT: {
                field.setBinaryV(tsPrimitiveType.getBinary());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException("UnSupported: " + dataType);
            }
        }
        return field;
    }

    private void timeHeapPut(long time) {
        this.timeHeap.add(time);
    }

    private Long timeHeapGet() {
        return this.timeHeap.pollFirst();
    }

    public List<IPointReader> getReaders() {
        return this.seriesReaderWithoutValueFilterList;
    }
}

