/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.control;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.JobFileManager;
import org.apache.iotdb.db.query.externalsort.serialize.IExternalSortFileDeserializer;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.expression.impl.SingleSeriesExpression;

public class QueryResourceManager {
    private JobFileManager filePathsManager = new JobFileManager();
    private AtomicLong maxJobId = new AtomicLong(0L);
    private Map<Long, List<IExternalSortFileDeserializer>> externalSortFileMap = new ConcurrentHashMap<Long, List<IExternalSortFileDeserializer>>();

    private QueryResourceManager() {
    }

    public static QueryResourceManager getInstance() {
        return QueryTokenManagerHelper.INSTANCE;
    }

    public long assignJobId() {
        long jobId = this.maxJobId.incrementAndGet();
        this.filePathsManager.addJobId(jobId);
        return jobId;
    }

    public void registerTempExternalSortFile(long jobId, IExternalSortFileDeserializer deserializer) {
        this.externalSortFileMap.computeIfAbsent(jobId, x -> new ArrayList()).add(deserializer);
    }

    public QueryDataSource getQueryDataSource(Path selectedPath, QueryContext context) throws StorageEngineException {
        SingleSeriesExpression singleSeriesExpression = new SingleSeriesExpression(selectedPath, null);
        return StorageEngine.getInstance().query(singleSeriesExpression, context, this.filePathsManager);
    }

    public void endQueryForGivenJob(long jobId) throws StorageEngineException {
        if (this.externalSortFileMap.get(jobId) != null) {
            for (IExternalSortFileDeserializer deserializer : this.externalSortFileMap.get(jobId)) {
                try {
                    deserializer.close();
                }
                catch (IOException e) {
                    throw new StorageEngineException(e.getMessage());
                }
            }
            this.externalSortFileMap.remove(jobId);
        }
        this.filePathsManager.removeUsedFilesForGivenJob(jobId);
    }

    private static class QueryTokenManagerHelper {
        private static final QueryResourceManager INSTANCE = new QueryResourceManager();

        private QueryTokenManagerHelper() {
        }
    }
}

