/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.aggregation.impl;

import java.io.IOException;
import org.apache.iotdb.db.query.aggregation.AggreResultData;
import org.apache.iotdb.db.query.aggregation.AggregateFunction;
import org.apache.iotdb.db.query.reader.IPointReader;
import org.apache.iotdb.db.query.reader.IReaderByTimestamp;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.BatchData;

public class MaxValueAggrFunc
extends AggregateFunction {
    public MaxValueAggrFunc(TSDataType dataType) {
        super(dataType);
    }

    @Override
    public void init() {
        this.resultData.reset();
    }

    @Override
    public AggreResultData getResult() {
        return this.resultData;
    }

    @Override
    public void calculateValueFromPageHeader(PageHeader pageHeader) {
        Comparable maxVal = (Comparable)pageHeader.getStatistics().getMax();
        this.updateResult(maxVal);
    }

    @Override
    public void calculateValueFromPageData(BatchData dataInThisPage, IPointReader unsequenceReader) throws IOException {
        Comparable maxVal = null;
        Object tmpVal = null;
        while (dataInThisPage.hasNext() && unsequenceReader.hasNext()) {
            if (dataInThisPage.currentTime() < unsequenceReader.current().getTimestamp()) {
                tmpVal = dataInThisPage.currentValue();
                dataInThisPage.next();
            } else if (dataInThisPage.currentTime() > unsequenceReader.current().getTimestamp()) {
                tmpVal = unsequenceReader.current().getValue().getValue();
                unsequenceReader.next();
            } else {
                tmpVal = unsequenceReader.current().getValue().getValue();
                dataInThisPage.next();
                unsequenceReader.next();
            }
            if (maxVal != null && maxVal.compareTo(tmpVal) >= 0) continue;
            maxVal = (Comparable)tmpVal;
        }
        while (dataInThisPage.hasNext()) {
            if (maxVal == null || maxVal.compareTo(dataInThisPage.currentValue()) < 0) {
                maxVal = (Comparable)dataInThisPage.currentValue();
            }
            dataInThisPage.next();
        }
        this.updateResult(maxVal);
    }

    @Override
    public void calculateValueFromPageData(BatchData dataInThisPage, IPointReader unsequenceReader, long bound) throws IOException {
        long time;
        Object tmpVal = null;
        while (dataInThisPage.hasNext() && unsequenceReader.hasNext() && (time = Math.min(dataInThisPage.currentTime(), unsequenceReader.current().getTimestamp())) < bound) {
            if (dataInThisPage.currentTime() == time) {
                tmpVal = dataInThisPage.currentValue();
                dataInThisPage.next();
            }
            if (unsequenceReader.current().getTimestamp() == time) {
                tmpVal = unsequenceReader.current().getValue().getValue();
                unsequenceReader.next();
            }
            this.updateResult((Comparable)tmpVal);
        }
        while (dataInThisPage.hasNext() && dataInThisPage.currentTime() < bound) {
            this.updateResult((Comparable)dataInThisPage.currentValue());
            dataInThisPage.next();
        }
    }

    @Override
    public void calculateValueFromUnsequenceReader(IPointReader unsequenceReader) throws IOException {
        Comparable maxVal = null;
        while (unsequenceReader.hasNext()) {
            if (maxVal == null || maxVal.compareTo(unsequenceReader.current().getValue().getValue()) < 0) {
                maxVal = (Comparable)unsequenceReader.current().getValue().getValue();
            }
            unsequenceReader.next();
        }
        this.updateResult(maxVal);
    }

    @Override
    public void calculateValueFromUnsequenceReader(IPointReader unsequenceReader, long bound) throws IOException {
        Comparable maxVal = null;
        while (unsequenceReader.hasNext() && unsequenceReader.current().getTimestamp() < bound) {
            if (maxVal == null || maxVal.compareTo(unsequenceReader.current().getValue().getValue()) < 0) {
                maxVal = (Comparable)unsequenceReader.current().getValue().getValue();
            }
            unsequenceReader.next();
        }
        this.updateResult(maxVal);
    }

    @Override
    public void calcAggregationUsingTimestamps(long[] timestamps, int length, IReaderByTimestamp dataReader) throws IOException {
        Comparable maxVal = null;
        for (int i = 0; i < length; ++i) {
            Object value = dataReader.getValueInTimestamp(timestamps[i]);
            if (value == null || maxVal != null && maxVal.compareTo(value) >= 0) continue;
            maxVal = (Comparable)value;
        }
        this.updateResult(maxVal);
    }

    @Override
    public boolean isCalculatedAggregationResult() {
        return false;
    }

    private void updateResult(Comparable<Object> maxVal) {
        if (maxVal == null) {
            return;
        }
        if (!this.resultData.isSetValue() || maxVal.compareTo(this.resultData.getValue()) > 0) {
            this.resultData.putTimeAndValue(0L, maxVal);
        }
    }
}

