/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.strategy.optimizer;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.LogicalOperatorException;
import org.apache.iotdb.db.exception.query.LogicalOptimizeException;
import org.apache.iotdb.db.qp.constant.SQLConstant;
import org.apache.iotdb.db.qp.executor.IQueryProcessExecutor;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.crud.BasicFunctionOperator;
import org.apache.iotdb.db.qp.logical.crud.FilterOperator;
import org.apache.iotdb.db.qp.logical.crud.FromOperator;
import org.apache.iotdb.db.qp.logical.crud.QueryOperator;
import org.apache.iotdb.db.qp.logical.crud.SFWOperator;
import org.apache.iotdb.db.qp.logical.crud.SelectOperator;
import org.apache.iotdb.db.qp.strategy.optimizer.ILogicalOptimizer;
import org.apache.iotdb.tsfile.read.common.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcatPathOptimizer
implements ILogicalOptimizer {
    private static final Logger logger = LoggerFactory.getLogger(ConcatPathOptimizer.class);
    private static final String WARNING_NO_SUFFIX_PATHS = "given SFWOperator doesn't have suffix paths, cannot concat seriesPath";
    private static final String WARNING_NO_PREFIX_PATHS = "given SFWOperator doesn't have prefix paths, cannot concat seriesPath";
    private IQueryProcessExecutor executor;

    public ConcatPathOptimizer(IQueryProcessExecutor executor) {
        this.executor = executor;
    }

    @Override
    public Operator transform(Operator operator) throws LogicalOptimizeException {
        FilterOperator filter;
        if (!(operator instanceof SFWOperator)) {
            logger.warn("given operator isn't SFWOperator, cannot concat seriesPath");
            return operator;
        }
        SFWOperator sfwOperator = (SFWOperator)operator;
        FromOperator from = sfwOperator.getFromOperator();
        if (from == null) {
            logger.warn(WARNING_NO_PREFIX_PATHS);
            return operator;
        }
        List<Path> prefixPaths = from.getPrefixPaths();
        if (prefixPaths.isEmpty()) {
            logger.warn(WARNING_NO_PREFIX_PATHS);
            return operator;
        }
        SelectOperator select = sfwOperator.getSelectOperator();
        if (select == null) {
            logger.warn(WARNING_NO_SUFFIX_PATHS);
            return operator;
        }
        List<Path> initialSuffixPaths = select.getSuffixPaths();
        if (initialSuffixPaths.isEmpty()) {
            logger.warn(WARNING_NO_SUFFIX_PATHS);
            return operator;
        }
        this.checkAggrOfSelectOperator(select);
        if (operator instanceof QueryOperator) {
            if (!((QueryOperator)operator).isGroupByDevice()) {
                this.concatSelect(prefixPaths, select);
                if (((QueryOperator)operator).hasSlimit()) {
                    int seriesLimit = ((QueryOperator)operator).getSeriesLimit();
                    int seriesOffset = ((QueryOperator)operator).getSeriesOffset();
                    this.slimitTrim(select, seriesLimit, seriesOffset);
                }
            } else {
                for (Path path : initialSuffixPaths) {
                    String device = path.getDevice();
                    if (device.isEmpty()) continue;
                    throw new LogicalOptimizeException("The paths of the SELECT clause can only be single level. In other words, the paths of the SELECT clause can only be measurements or STAR, without DOT. For more details please refer to the SQL document.");
                }
            }
        }
        if ((filter = sfwOperator.getFilterOperator()) == null) {
            return operator;
        }
        sfwOperator.setFilterOperator(this.concatFilter(prefixPaths, filter));
        return sfwOperator;
    }

    private List<Path> judgeSelectOperator(SelectOperator selectOperator) throws LogicalOptimizeException {
        if (selectOperator == null) {
            throw new LogicalOptimizeException(WARNING_NO_SUFFIX_PATHS);
        }
        List<Path> suffixPaths = selectOperator.getSuffixPaths();
        if (suffixPaths.isEmpty()) {
            throw new LogicalOptimizeException(WARNING_NO_SUFFIX_PATHS);
        }
        return suffixPaths;
    }

    private void checkAggrOfSelectOperator(SelectOperator selectOperator) throws LogicalOptimizeException {
        if (!selectOperator.getAggregations().isEmpty() && selectOperator.getSuffixPaths().size() != selectOperator.getAggregations().size()) {
            throw new LogicalOptimizeException("Common queries and aggregated queries are not allowed to appear at the same time");
        }
    }

    private void extendListSafely(List<String> source, int index, List<String> target) {
        if (source != null && !source.isEmpty()) {
            target.add(source.get(index));
        }
    }

    private void concatSelect(List<Path> fromPaths, SelectOperator selectOperator) throws LogicalOptimizeException {
        List<Path> suffixPaths = this.judgeSelectOperator(selectOperator);
        ArrayList<Path> allPaths = new ArrayList<Path>();
        List<String> originAggregations = selectOperator.getAggregations();
        ArrayList<String> afterConcatAggregations = new ArrayList<String>();
        for (int i = 0; i < suffixPaths.size(); ++i) {
            Path selectPath = suffixPaths.get(i);
            for (Path fromPath : fromPaths) {
                allPaths.add(Path.addPrefixPath((Path)selectPath, (Path)fromPath));
                this.extendListSafely(originAggregations, i, afterConcatAggregations);
            }
        }
        this.removeStarsInPath(allPaths, afterConcatAggregations, selectOperator);
    }

    public void slimitTrim(SelectOperator select, int seriesLimit, int seriesOffset) throws LogicalOptimizeException {
        List<Path> suffixList = select.getSuffixPaths();
        List<String> aggregations = select.getAggregations();
        int size = suffixList.size();
        if (seriesOffset >= size) {
            throw new LogicalOptimizeException("SOFFSET <SOFFSETValue>: SOFFSETValue exceeds the range.");
        }
        int endPosition = seriesOffset + seriesLimit;
        if (endPosition > size) {
            endPosition = size;
        }
        ArrayList<Path> trimedSuffixList = new ArrayList<Path>(suffixList.subList(seriesOffset, endPosition));
        select.setSuffixPathList(trimedSuffixList);
        if (aggregations != null && !aggregations.isEmpty()) {
            ArrayList<String> trimedAggregations = new ArrayList<String>(aggregations.subList(seriesOffset, endPosition));
            select.setAggregations(trimedAggregations);
        }
    }

    private FilterOperator concatFilter(List<Path> fromPaths, FilterOperator operator) throws LogicalOptimizeException {
        if (!operator.isLeaf()) {
            ArrayList<FilterOperator> newFilterList = new ArrayList<FilterOperator>();
            for (FilterOperator child : operator.getChildren()) {
                newFilterList.add(this.concatFilter(fromPaths, child));
            }
            operator.setChildren(newFilterList);
            return operator;
        }
        BasicFunctionOperator basicOperator = (BasicFunctionOperator)operator;
        Path filterPath = basicOperator.getSinglePath();
        if (SQLConstant.isReservedPath(filterPath) || filterPath.startWith("root")) {
            return operator;
        }
        ArrayList<Path> concatPaths = new ArrayList<Path>();
        fromPaths.forEach(fromPath -> concatPaths.add(Path.addPrefixPath((Path)filterPath, (Path)fromPath)));
        List<Path> noStarPaths = this.removeStarsInPathWithUnique(concatPaths);
        if (noStarPaths.size() == 1) {
            basicOperator.setSinglePath(noStarPaths.get(0));
            return operator;
        }
        return this.constructTwoForkFilterTreeWithAnd(noStarPaths, operator);
    }

    private FilterOperator constructTwoForkFilterTreeWithAnd(List<Path> noStarPaths, FilterOperator operator) throws LogicalOptimizeException {
        FilterOperator filterTwoFolkTree;
        FilterOperator currentNode = filterTwoFolkTree = new FilterOperator(1);
        for (int i = 0; i < noStarPaths.size(); ++i) {
            if (i > 0 && i < noStarPaths.size() - 1) {
                FilterOperator newInnerNode = new FilterOperator(1);
                currentNode.addChildOperator(newInnerNode);
                currentNode = newInnerNode;
            }
            try {
                currentNode.addChildOperator(new BasicFunctionOperator(operator.getTokenIntType(), noStarPaths.get(i), ((BasicFunctionOperator)operator).getValue()));
                continue;
            }
            catch (LogicalOperatorException e) {
                throw new LogicalOptimizeException(e.getMessage());
            }
        }
        return filterTwoFolkTree;
    }

    private List<Path> removeStarsInPathWithUnique(List<Path> paths) throws LogicalOptimizeException {
        ArrayList<Path> retPaths = new ArrayList<Path>();
        LinkedHashMap<String, Integer> pathMap = new LinkedHashMap<String, Integer>();
        try {
            for (Path path : paths) {
                List<String> all = this.executor.getAllPaths(path.getFullPath());
                if (all.isEmpty()) {
                    throw new LogicalOptimizeException("Path: \"" + path + "\" doesn't correspond to any known time series");
                }
                for (String subPath : all) {
                    if (pathMap.containsKey(subPath)) continue;
                    pathMap.put(subPath, 1);
                }
            }
            for (String pathStr : pathMap.keySet()) {
                retPaths.add(new Path(pathStr));
            }
        }
        catch (MetadataException e) {
            throw new LogicalOptimizeException("error when remove star: " + e.getMessage());
        }
        return retPaths;
    }

    private void removeStarsInPath(List<Path> paths, List<String> afterConcatAggregations, SelectOperator selectOperator) throws LogicalOptimizeException {
        ArrayList<Path> retPaths = new ArrayList<Path>();
        ArrayList<String> newAggregations = new ArrayList<String>();
        for (int i = 0; i < paths.size(); ++i) {
            try {
                List<String> actualPaths = this.executor.getAllPaths(paths.get(i).getFullPath());
                for (String actualPath : actualPaths) {
                    retPaths.add(new Path(actualPath));
                    if (afterConcatAggregations == null || afterConcatAggregations.isEmpty()) continue;
                    newAggregations.add(afterConcatAggregations.get(i));
                }
                continue;
            }
            catch (MetadataException e) {
                throw new LogicalOptimizeException("error when remove star: " + e.getMessage());
            }
        }
        selectOperator.setSuffixPathList(retPaths);
        selectOperator.setAggregations(newAggregations);
    }
}

