/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.Path;

public class CreateTimeSeriesPlan
extends PhysicalPlan {
    private Path path;
    private TSDataType dataType;
    private TSEncoding encoding;
    private CompressionType compressor;
    private Map<String, String> props;

    public CreateTimeSeriesPlan(Path path, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props) {
        super(false, Operator.OperatorType.CREATE_TIMESERIES);
        this.path = path;
        this.dataType = dataType;
        this.encoding = encoding;
        this.compressor = compressor;
        this.props = props;
    }

    public Path getPath() {
        return this.path;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public TSDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(TSDataType dataType) {
        this.dataType = dataType;
    }

    public CompressionType getCompressor() {
        return this.compressor;
    }

    public void setCompressor(CompressionType compressor) {
        this.compressor = compressor;
    }

    public TSEncoding getEncoding() {
        return this.encoding;
    }

    public void setEncoding(TSEncoding encoding) {
        this.encoding = encoding;
    }

    public Map<String, String> getProps() {
        return this.props;
    }

    public void setProps(Map<String, String> props) {
        this.props = props;
    }

    public String toString() {
        String ret = String.format("seriesPath: %s%nresultDataType: %s%nencoding: %s%nnamespace type: ADD_PATH%nargs: ", this.path, this.dataType, this.encoding);
        StringBuilder stringBuilder = new StringBuilder(ret.length() + 50);
        stringBuilder.append(ret);
        for (Map.Entry<String, String> prop : this.props.entrySet()) {
            stringBuilder.append(prop.getKey()).append("=").append(prop.getValue()).append(",");
        }
        return stringBuilder.toString();
    }

    @Override
    public List<Path> getPaths() {
        return Collections.singletonList(this.path);
    }
}

