/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.executor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.metadata.MNode;
import org.apache.iotdb.db.qp.executor.IQueryProcessExecutor;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.AggregationPlan;
import org.apache.iotdb.db.qp.physical.crud.DeletePlan;
import org.apache.iotdb.db.qp.physical.crud.FillQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.GroupByPlan;
import org.apache.iotdb.db.qp.physical.crud.QueryPlan;
import org.apache.iotdb.db.qp.physical.sys.AuthorPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTTLPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.dataset.DeviceIterateDataSet;
import org.apache.iotdb.db.query.dataset.ListDataSet;
import org.apache.iotdb.db.query.executor.EngineQueryRouter;
import org.apache.iotdb.db.query.executor.IEngineQueryRouter;
import org.apache.iotdb.tsfile.exception.filter.QueryFilterOptimizationException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.expression.QueryExpression;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.utils.Binary;

public abstract class AbstractQueryProcessExecutor
implements IQueryProcessExecutor {
    IEngineQueryRouter queryRouter = new EngineQueryRouter();

    @Override
    public QueryDataSet processQuery(PhysicalPlan queryPlan, QueryContext context) throws IOException, StorageEngineException, QueryFilterOptimizationException, QueryProcessException {
        if (queryPlan instanceof QueryPlan) {
            return this.processDataQuery((QueryPlan)queryPlan, context);
        }
        if (queryPlan instanceof AuthorPlan) {
            return this.processAuthorQuery((AuthorPlan)queryPlan, context);
        }
        if (queryPlan instanceof ShowTTLPlan) {
            return this.processShowTTLQuery((ShowTTLPlan)queryPlan);
        }
        throw new QueryProcessException(String.format("Unrecognized query plan %s", queryPlan));
    }

    private QueryDataSet processShowTTLQuery(ShowTTLPlan showTTLPlan) {
        ArrayList<Path> paths = new ArrayList<Path>();
        paths.add(new Path("storage group"));
        paths.add(new Path("ttl"));
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        dataTypes.add(TSDataType.TEXT);
        dataTypes.add(TSDataType.INT64);
        ListDataSet listDataSet = new ListDataSet(paths, dataTypes);
        List<String> selectedSgs = showTTLPlan.getStorageGroups();
        List<MNode> storageGroups = MManager.getInstance().getAllStorageGroups();
        int i = 0;
        for (MNode mNode : storageGroups) {
            Field ttl;
            String sgName = mNode.getFullPath();
            if (!selectedSgs.isEmpty() && !selectedSgs.contains(sgName)) continue;
            RowRecord rowRecord = new RowRecord((long)i++);
            Field sg = new Field(TSDataType.TEXT);
            sg.setBinaryV(new Binary(sgName));
            if (mNode.getDataTTL() != Long.MAX_VALUE) {
                ttl = new Field(TSDataType.INT64);
                ttl.setLongV(mNode.getDataTTL());
            } else {
                ttl = new Field(null);
            }
            rowRecord.addField(sg);
            rowRecord.addField(ttl);
            listDataSet.putRecord(rowRecord);
        }
        return listDataSet;
    }

    protected abstract QueryDataSet processAuthorQuery(AuthorPlan var1, QueryContext var2) throws QueryProcessException;

    private QueryDataSet processDataQuery(QueryPlan queryPlan, QueryContext context) throws StorageEngineException, QueryFilterOptimizationException, QueryProcessException, IOException {
        if (queryPlan.isGroupByDevice()) {
            return new DeviceIterateDataSet(queryPlan, context, this.queryRouter);
        }
        ArrayList<Path> deduplicatedPaths = new ArrayList<Path>();
        if (queryPlan instanceof GroupByPlan) {
            GroupByPlan groupByPlan = (GroupByPlan)queryPlan;
            ArrayList<String> deduplicatedAggregations = new ArrayList<String>();
            this.deduplicate(groupByPlan.getPaths(), groupByPlan.getAggregations(), deduplicatedPaths, deduplicatedAggregations);
            return this.groupBy(deduplicatedPaths, deduplicatedAggregations, groupByPlan.getExpression(), groupByPlan.getUnit(), groupByPlan.getOrigin(), groupByPlan.getIntervals(), context);
        }
        if (queryPlan instanceof AggregationPlan) {
            ArrayList<String> deduplicatedAggregations = new ArrayList<String>();
            this.deduplicate(queryPlan.getPaths(), queryPlan.getAggregations(), deduplicatedPaths, deduplicatedAggregations);
            return this.aggregate(deduplicatedPaths, deduplicatedAggregations, queryPlan.getExpression(), context);
        }
        if (queryPlan instanceof FillQueryPlan) {
            FillQueryPlan fillQueryPlan = (FillQueryPlan)queryPlan;
            this.deduplicate(queryPlan.getPaths(), deduplicatedPaths);
            return this.fill(deduplicatedPaths, fillQueryPlan.getQueryTime(), fillQueryPlan.getFillType(), context);
        }
        this.deduplicate(queryPlan.getPaths(), deduplicatedPaths);
        QueryExpression queryExpression = QueryExpression.create().setSelectSeries(deduplicatedPaths).setExpression(queryPlan.getExpression());
        return this.queryRouter.query(queryExpression, context);
    }

    private void deduplicate(List<Path> paths, List<String> aggregations, List<Path> deduplicatedPaths, List<String> deduplicatedAggregations) throws QueryProcessException {
        if (paths == null || aggregations == null || deduplicatedPaths == null || deduplicatedAggregations == null) {
            throw new QueryProcessException("Parameters should not be null.");
        }
        if (paths.size() != aggregations.size()) {
            throw new QueryProcessException("The size of the path list does not equal that of the aggregation list.");
        }
        HashSet<String> columnSet = new HashSet<String>();
        for (int i = 0; i < paths.size(); ++i) {
            String column = aggregations.get(i) + "(" + paths.get(i).toString() + ")";
            if (columnSet.contains(column)) continue;
            deduplicatedPaths.add(paths.get(i));
            deduplicatedAggregations.add(aggregations.get(i));
            columnSet.add(column);
        }
    }

    private void deduplicate(List<Path> paths, List<Path> deduplicatedPaths) throws QueryProcessException {
        if (paths == null || deduplicatedPaths == null) {
            throw new QueryProcessException("Parameters should not be null.");
        }
        HashSet<String> columnSet = new HashSet<String>();
        for (Path path : paths) {
            String column = path.toString();
            if (columnSet.contains(column)) continue;
            deduplicatedPaths.add(path);
            columnSet.add(column);
        }
    }

    @Override
    public void delete(DeletePlan deletePlan) throws QueryProcessException {
        try {
            MManager mManager = MManager.getInstance();
            HashSet<String> existingPaths = new HashSet<String>();
            for (Path p : deletePlan.getPaths()) {
                existingPaths.addAll(mManager.getPaths(p.getFullPath()));
            }
            if (existingPaths.isEmpty()) {
                throw new QueryProcessException("TimeSeries does not exist and its data cannot be deleted");
            }
            for (String onePath : existingPaths) {
                if (mManager.pathExist(onePath)) continue;
                throw new QueryProcessException(String.format("TimeSeries %s does not exist and its data cannot be deleted", onePath));
            }
            for (String path : existingPaths) {
                this.delete(new Path(path), deletePlan.getDeleteTime());
            }
        }
        catch (MetadataException e) {
            throw new QueryProcessException(e);
        }
    }
}

