/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.path.MTreePathException;
import org.apache.iotdb.db.exception.path.PathException;
import org.apache.iotdb.db.exception.storageGroup.StorageGroupException;
import org.apache.iotdb.db.exception.storageGroup.StorageGroupNotSetException;
import org.apache.iotdb.db.exception.storageGroup.StorageGroupPathException;
import org.apache.iotdb.db.metadata.MNode;
import org.apache.iotdb.db.metadata.MetaUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class MTree
implements Serializable {
    private static final long serialVersionUID = -4200394435237291964L;
    private static final String PATH_SEPARATOR = "\\.";
    private static final String NO_CHILD_ERROR = "Node [%s] doesn't have child named: [%s]";
    private static final String NOT_LEAF_NODE = "is NOT the leaf node";
    private MNode root;

    MTree(String rootName) {
        this.root = new MNode(rootName, null, false);
    }

    void addTimeseriesPath(String timeseriesPath, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props) throws PathException {
        String[] nodeNames = MetaUtils.getNodeNames(timeseriesPath, PATH_SEPARATOR);
        if (nodeNames.length <= 1 || !nodeNames[0].equals(this.root.getName())) {
            throw new MTreePathException("Timeseries", timeseriesPath);
        }
        MNode cur = this.findLeafParent(nodeNames);
        String levelPath = cur.getDataFileName();
        MNode leaf = new MNode(nodeNames[nodeNames.length - 1], cur, dataType, encoding, compressor);
        if (props != null && !props.isEmpty()) {
            leaf.getSchema().setProps(props);
        }
        leaf.setDataFileName(levelPath);
        if (cur.isLeaf()) {
            throw new MTreePathException(timeseriesPath, "can't be created", String.format("node [%s] is left node", cur.getName()));
        }
        cur.addChild(nodeNames[nodeNames.length - 1], leaf);
    }

    MNode addDeviceId(String deviceId) throws PathException {
        String[] nodeNames = MetaUtils.getNodeNames(deviceId, PATH_SEPARATOR);
        if (nodeNames.length <= 1 || !nodeNames[0].equals(this.root.getName())) {
            throw new MTreePathException("Timeseries", deviceId);
        }
        MNode cur = this.getRoot();
        for (int i = 1; i < nodeNames.length; ++i) {
            if (!cur.hasChild(nodeNames[i])) {
                cur.addChild(nodeNames[i], new MNode(nodeNames[i], cur, false));
            }
            cur = cur.getChild(nodeNames[i]);
        }
        return cur;
    }

    private MNode findLeafParent(String[] nodeNames) throws PathException {
        MNode cur = this.root;
        String levelPath = null;
        for (int i = 1; i < nodeNames.length - 1; ++i) {
            String nodeName = nodeNames[i];
            if (cur.isStorageGroup()) {
                levelPath = cur.getDataFileName();
            }
            if (!cur.hasChild(nodeName)) {
                if (cur.isLeaf()) {
                    throw new MTreePathException(String.join((CharSequence)",", nodeNames), "can't be created", String.format("node [%s] is left node", cur.getName()));
                }
                cur.addChild(nodeName, new MNode(nodeName, cur, false));
            }
            cur.setDataFileName(levelPath);
            cur = cur.getChild(nodeName);
            if (levelPath != null) continue;
            levelPath = cur.getDataFileName();
        }
        cur.setDataFileName(levelPath);
        return cur;
    }

    boolean isPathExist(String path) {
        String[] nodeNames = MetaUtils.getNodeNames(path, PATH_SEPARATOR);
        MNode cur = this.root;
        int i = 0;
        while (i < nodeNames.length - 1) {
            String nodeName = nodeNames[i];
            if (cur.getName().equals(nodeName)) {
                if (cur.hasChild(nodeName = nodeNames[++i])) {
                    cur = cur.getChild(nodeName);
                    continue;
                }
                return false;
            }
            return false;
        }
        return cur.getName().equals(nodeNames[i]);
    }

    boolean isPathExist(MNode node, String path) {
        String[] nodeNames = MetaUtils.getNodeNames(path, PATH_SEPARATOR);
        if (nodeNames.length < 1) {
            return true;
        }
        if (!node.hasChild(nodeNames[0])) {
            return false;
        }
        MNode cur = node.getChild(nodeNames[0]);
        int i = 0;
        while (i < nodeNames.length - 1) {
            String nodeName = nodeNames[i];
            if (cur.getName().equals(nodeName)) {
                if (cur.hasChild(nodeName = nodeNames[++i])) {
                    cur = cur.getChild(nodeName);
                    continue;
                }
                return false;
            }
            return false;
        }
        return cur.getName().equals(nodeNames[i]);
    }

    public void setStorageGroup(String path) throws StorageGroupException {
        MNode temp;
        int i;
        String[] nodeNames = MetaUtils.getNodeNames(path, PATH_SEPARATOR);
        MNode cur = this.root;
        if (nodeNames.length <= 1 || !nodeNames[0].equals(this.root.getName())) {
            throw new StorageGroupException(String.format("The storage group can't be set to [%s] node", path));
        }
        for (i = 1; i < nodeNames.length - 1; ++i) {
            temp = cur.getChild(nodeNames[i]);
            if (temp == null) {
                cur.addChild(nodeNames[i], new MNode(nodeNames[i], cur, false));
            } else if (temp.isStorageGroup()) {
                throw new StorageGroupException(String.format("The prefix of [%s] has been set to the storage group.", path));
            }
            cur = cur.getChild(nodeNames[i]);
        }
        temp = cur.getChild(nodeNames[i]);
        if (temp != null) {
            throw new StorageGroupException(String.format("The seriesPath of [%s] already exist, it can't be set to the storage group", path));
        }
        cur.addChild(nodeNames[i], new MNode(nodeNames[i], cur, false));
        cur = cur.getChild(nodeNames[i]);
        cur.setDataTTL(IoTDBDescriptor.getInstance().getConfig().getDefaultTTL());
        cur.setStorageGroup(true);
        this.setStorageGroup(path, cur);
    }

    void deleteStorageGroup(String path) throws PathException {
        MNode cur = this.getNode(path);
        if (!cur.isStorageGroup()) {
            throw new MTreePathException(String.format("The path [%s] is not a deletable storage group", path));
        }
        cur.getParent().deleteChild(cur.getName());
        for (cur = cur.getParent(); cur != null && !"root".equals(cur.getName()) && cur.getChildren().size() == 0; cur = cur.getParent()) {
            cur.getParent().deleteChild(cur.getName());
        }
    }

    boolean checkStorageGroup(String path) {
        MNode temp;
        int i;
        String[] nodeNames = MetaUtils.getNodeNames(path, PATH_SEPARATOR);
        MNode cur = this.root;
        if (nodeNames.length <= 1 || !nodeNames[0].equals(this.root.getName())) {
            return false;
        }
        for (i = 1; i < nodeNames.length - 1; ++i) {
            temp = cur.getChild(nodeNames[i]);
            if (temp == null || temp.isStorageGroup()) {
                return false;
            }
            cur = cur.getChild(nodeNames[i]);
        }
        temp = cur.getChild(nodeNames[i]);
        return temp != null && temp.isStorageGroup();
    }

    private void setStorageGroup(String path, MNode node) {
        node.setDataFileName(path);
        if (node.getChildren() == null) {
            return;
        }
        for (MNode child : node.getChildren().values()) {
            this.setStorageGroup(path, child);
        }
    }

    String deletePath(String path) throws PathException {
        String[] nodes = MetaUtils.getNodeNames(path, PATH_SEPARATOR);
        if (nodes.length == 0 || !nodes[0].equals(this.getRoot().getName())) {
            throw new MTreePathException("Timeseries", path);
        }
        MNode cur = this.getRoot();
        for (int i = 1; i < nodes.length; ++i) {
            if (!cur.hasChild(nodes[i])) {
                throw new MTreePathException("", "is not correct", String.format(NO_CHILD_ERROR, cur.getName(), nodes[i]));
            }
            cur = cur.getChild(nodes[i]);
        }
        String dataFileName = null;
        if (cur.isStorageGroup()) {
            dataFileName = cur.getDataFileName();
        }
        cur.getParent().deleteChild(cur.getName());
        for (cur = cur.getParent(); cur != null && !"root".equals(cur.getName()) && cur.getChildren().size() == 0; cur = cur.getParent()) {
            if (cur.isStorageGroup()) {
                dataFileName = cur.getDataFileName();
                return dataFileName;
            }
            cur.getParent().deleteChild(cur.getName());
        }
        return dataFileName;
    }

    MeasurementSchema getSchemaForOnePath(String path) throws PathException {
        MNode leaf = this.getLeafByPath(path);
        return leaf.getSchema();
    }

    MeasurementSchema getSchemaForOnePath(MNode node, String path) throws PathException {
        MNode leaf = this.getLeafByPath(node, path);
        return leaf.getSchema();
    }

    MeasurementSchema getSchemaForOnePathWithCheck(MNode node, String path) throws PathException {
        MNode leaf = this.getLeafByPathWithCheck(node, path);
        return leaf.getSchema();
    }

    MeasurementSchema getSchemaForOnePathWithCheck(String path) throws PathException {
        MNode leaf = this.getLeafByPathWithCheck(path);
        return leaf.getSchema();
    }

    private MNode getLeafByPath(String path) throws PathException {
        this.getNode(path);
        String[] node = MetaUtils.getNodeNames(path, PATH_SEPARATOR);
        MNode cur = this.getRoot();
        for (int i = 1; i < node.length; ++i) {
            cur = cur.getChild(node[i]);
        }
        if (!cur.isLeaf()) {
            throw new MTreePathException(path, NOT_LEAF_NODE, "");
        }
        return cur;
    }

    private MNode getLeafByPath(MNode node, String path) throws PathException {
        String[] nodes = MetaUtils.getNodeNames(path, PATH_SEPARATOR);
        MNode cur = node.getChild(nodes[0]);
        for (int i = 1; i < nodes.length; ++i) {
            cur = cur.getChild(nodes[i]);
        }
        if (!cur.isLeaf()) {
            throw new MTreePathException(path, NOT_LEAF_NODE, "");
        }
        return cur;
    }

    private MNode getLeafByPathWithCheck(MNode node, String path) throws PathException {
        String[] nodes = MetaUtils.getNodeNames(path, PATH_SEPARATOR);
        if (nodes.length < 1 || !node.hasChild(nodes[0])) {
            throw new MTreePathException("Timeseries", path);
        }
        MNode cur = node.getChild(nodes[0]);
        for (int i = 1; i < nodes.length; ++i) {
            if (!cur.hasChild(nodes[i])) {
                throw new MTreePathException("", "is not correct", String.format(NO_CHILD_ERROR, cur.getName(), nodes[i]));
            }
            cur = cur.getChild(nodes[i]);
        }
        if (!cur.isLeaf()) {
            throw new MTreePathException(path, NOT_LEAF_NODE, "");
        }
        return cur;
    }

    private MNode getLeafByPathWithCheck(String path) throws PathException {
        String[] nodes = MetaUtils.getNodeNames(path, PATH_SEPARATOR);
        if (nodes.length < 2 || !nodes[0].equals(this.getRoot().getName())) {
            throw new MTreePathException("Timeseries", path);
        }
        MNode cur = this.getRoot();
        for (int i = 1; i < nodes.length; ++i) {
            if (!cur.hasChild(nodes[i])) {
                throw new MTreePathException("", "is not correct", String.format(NO_CHILD_ERROR, cur.getName(), nodes[i]));
            }
            cur = cur.getChild(nodes[i]);
        }
        if (!cur.isLeaf()) {
            throw new MTreePathException(path, NOT_LEAF_NODE, "");
        }
        return cur;
    }

    MNode getNodeByPathWithStorageGroupCheck(String path) throws PathException, StorageGroupException {
        boolean storageGroupChecked = false;
        String[] nodes = MetaUtils.getNodeNames(path, PATH_SEPARATOR);
        if (nodes.length < 2 || !nodes[0].equals(this.getRoot().getName())) {
            throw new MTreePathException("Timeseries", path);
        }
        MNode cur = this.getRoot();
        for (int i = 1; i < nodes.length; ++i) {
            if (!cur.hasChild(nodes[i])) {
                if (!storageGroupChecked) {
                    throw new StorageGroupNotSetException(path);
                }
                throw new MTreePathException("", "is not correct", String.format(NO_CHILD_ERROR, cur.getName(), nodes[i]));
            }
            if (!(cur = cur.getChild(nodes[i])).isStorageGroup()) continue;
            storageGroupChecked = true;
        }
        if (!storageGroupChecked) {
            throw new StorageGroupNotSetException(path);
        }
        return cur;
    }

    MNode getNode(String path) throws PathException {
        String[] nodes = MetaUtils.getNodeNames(path, PATH_SEPARATOR);
        if (nodes.length < 2 || !nodes[0].equals(this.getRoot().getName())) {
            throw new MTreePathException("Timeseries", path);
        }
        MNode cur = this.getRoot();
        for (int i = 1; i < nodes.length; ++i) {
            if (!cur.hasChild(nodes[i])) {
                throw new MTreePathException("Path: [" + path + "] doesn't correspond to any known time series");
            }
            cur = cur.getChild(nodes[i]);
        }
        return cur;
    }

    private void checkPath(MNode node, String path) throws PathException {
        String[] nodes = MetaUtils.getNodeNames(path, PATH_SEPARATOR);
        if (nodes.length < 1) {
            return;
        }
        MNode cur = node;
        for (String node1 : nodes) {
            if (!cur.hasChild(node1)) {
                throw new MTreePathException("", "is not correct", String.format(NO_CHILD_ERROR, cur.getName(), node1));
            }
            cur = cur.getChild(node1);
        }
    }

    String getStorageGroupNameByPath(String path) throws StorageGroupException {
        String[] nodes = MetaUtils.getNodeNames(path, PATH_SEPARATOR);
        MNode cur = this.getRoot();
        for (int i = 1; i < nodes.length; ++i) {
            if (cur == null) {
                throw new StorageGroupPathException(path);
            }
            if (cur.isStorageGroup()) {
                return cur.getDataFileName();
            }
            cur = cur.getChild(nodes[i]);
        }
        if (cur.isStorageGroup()) {
            return cur.getDataFileName();
        }
        throw new StorageGroupPathException(path);
    }

    List<String> getAllFileNamesByPath(String pathReg) throws PathException {
        ArrayList<String> fileNames = new ArrayList<String>();
        String[] nodes = MetaUtils.getNodeNames(pathReg, PATH_SEPARATOR);
        if (nodes.length == 0 || !nodes[0].equals(this.getRoot().getName())) {
            throw new MTreePathException("Timeseries", pathReg);
        }
        this.findFileName(this.getRoot(), nodes, 1, "", fileNames);
        return fileNames;
    }

    private void findFileName(MNode node, String[] nodes, int idx, String parent, ArrayList<String> paths) {
        if (node.isStorageGroup()) {
            paths.add(node.getDataFileName());
            return;
        }
        String nodeReg = idx >= nodes.length ? "*" : nodes[idx];
        if (!"*".equals(nodeReg)) {
            if (node.hasChild(nodeReg)) {
                this.findFileName(node.getChild(nodeReg), nodes, idx + 1, parent + node.getName() + ".", paths);
            }
        } else {
            for (MNode child : node.getChildren().values()) {
                this.findFileName(child, nodes, idx + 1, parent + node.getName() + ".", paths);
            }
        }
    }

    String getStorageGroupNameByPath(MNode node, String path) throws StorageGroupException {
        String[] nodes = MetaUtils.getNodeNames(path, PATH_SEPARATOR);
        MNode cur = node.getChild(nodes[0]);
        for (int i = 1; i < nodes.length; ++i) {
            if (cur == null) {
                throw new StorageGroupPathException(path);
            }
            if (cur.isStorageGroup()) {
                return cur.getDataFileName();
            }
            cur = cur.getChild(nodes[i]);
        }
        if (cur.isStorageGroup()) {
            return cur.getDataFileName();
        }
        throw new StorageGroupPathException(path);
    }

    boolean checkFileNameByPath(String path) {
        String[] nodes = MetaUtils.getNodeNames(path, PATH_SEPARATOR);
        MNode cur = this.getRoot();
        for (int i = 1; i <= nodes.length; ++i) {
            if (cur == null) {
                return false;
            }
            if (cur.isStorageGroup()) {
                return true;
            }
            cur = cur.getChild(nodes[i]);
        }
        return false;
    }

    HashMap<String, List<String>> getAllPath(String pathReg) throws PathException {
        HashMap<String, List<String>> paths = new HashMap<String, List<String>>();
        String[] nodes = MetaUtils.getNodeNames(pathReg, PATH_SEPARATOR);
        if (nodes.length == 0 || !nodes[0].equals(this.getRoot().getName())) {
            throw new MTreePathException("Timeseries", pathReg);
        }
        this.findPath(this.getRoot(), nodes, 1, "", paths);
        return paths;
    }

    List<MNode> getAllStorageGroupNodes() {
        ArrayList<MNode> ret = new ArrayList<MNode>();
        Stack<MNode> nodeStack = new Stack<MNode>();
        nodeStack.add(this.getRoot());
        while (!nodeStack.isEmpty()) {
            MNode current = (MNode)nodeStack.pop();
            if (current.isStorageGroup()) {
                ret.add(current);
                continue;
            }
            if (!current.hasChildren()) continue;
            nodeStack.addAll(current.getChildren().values());
        }
        return ret;
    }

    List<List<String>> getShowTimeseriesPath(String pathReg) throws PathException {
        ArrayList<List<String>> res = new ArrayList<List<String>>();
        String[] nodes = MetaUtils.getNodeNames(pathReg, PATH_SEPARATOR);
        if (nodes.length == 0 || !nodes[0].equals(this.getRoot().getName())) {
            throw new MTreePathException("Timeseries", pathReg);
        }
        this.findPath(this.getRoot(), nodes, 1, "", res);
        return res;
    }

    List<String> getLeafNodePathInNextLevel(String path) throws PathException {
        ArrayList<String> ret = new ArrayList<String>();
        MNode cur = this.getNode(path);
        for (MNode child : cur.getChildren().values()) {
            if (!child.isLeaf()) continue;
            ret.add(path + "." + child.getName());
        }
        return ret;
    }

    Set<String> getChildNodePathInNextLevel(String path) throws PathException {
        HashSet<String> ret = new HashSet<String>();
        String[] nodes = MetaUtils.getNodeNames(path, PATH_SEPARATOR);
        if (!nodes[0].equals(this.getRoot().getName())) {
            throw new MTreePathException("The prefix of the seriesPath [%s] is not one storage group seriesPath", path);
        }
        MNode cur = this.getRoot();
        for (int i = 1; i < nodes.length; ++i) {
            if (!cur.hasChild(nodes[i])) {
                throw new MTreePathException("Path: \"" + path + "\" doesn't correspond to any known time series");
            }
            cur = cur.getChild(nodes[i]);
        }
        if (!cur.hasChildren()) {
            throw new MTreePathException("Path: \"" + path + "\" doesn't have a child node");
        }
        for (MNode child : cur.getChildren().values()) {
            ret.add(path + "." + child.getName());
        }
        return ret;
    }

    List<String> getAllPathInList(String path) throws PathException {
        ArrayList<String> res = new ArrayList<String>();
        HashMap<String, List<String>> mapRet = this.getAllPath(path);
        for (List<String> value : mapRet.values()) {
            res.addAll(value);
        }
        return res;
    }

    int getFileCountForOneType(String path) throws PathException {
        String[] nodes = MetaUtils.getNodeNames(path, PATH_SEPARATOR);
        if (nodes.length != 2 || !nodes[0].equals(this.getRoot().getName()) || !this.getRoot().hasChild(nodes[1])) {
            throw new MTreePathException("Timeseries must be " + this.getRoot().getName() + ". X (X is one of the nodes of root's children)");
        }
        return this.getFileCountForOneNode(this.getRoot().getChild(nodes[1]));
    }

    private int getFileCountForOneNode(MNode node) {
        if (node.isStorageGroup()) {
            return 1;
        }
        int sum = 0;
        if (!node.isLeaf()) {
            for (MNode child : node.getChildren().values()) {
                sum += this.getFileCountForOneNode(child);
            }
        }
        return sum;
    }

    ArrayList<String> getAllType() {
        ArrayList<String> res = new ArrayList<String>();
        if (this.getRoot() != null) {
            res.addAll(this.getRoot().getChildren().keySet());
        }
        return res;
    }

    List<String> getAllStorageGroupList() {
        ArrayList<String> res = new ArrayList<String>();
        MNode rootNode = this.getRoot();
        if (rootNode != null) {
            this.findStorageGroup(rootNode, "root", res);
        }
        return res;
    }

    private void findStorageGroup(MNode node, String path, List<String> res) {
        if (node.isStorageGroup()) {
            res.add(path);
            return;
        }
        for (MNode childNode : node.getChildren().values()) {
            this.findStorageGroup(childNode, path + "." + childNode.toString(), res);
        }
    }

    Set<String> getAllDevices() {
        HashSet<String> devices = new HashSet<String>();
        MNode node = this.getRoot();
        if (node != null) {
            this.findDevices(node, "root", devices);
        }
        return new LinkedHashSet<String>(devices);
    }

    private void findDevices(MNode node, String path, HashSet<String> res) {
        if (node == null) {
            return;
        }
        if (node.isLeaf()) {
            res.add(path);
            return;
        }
        for (MNode child : node.getChildren().values()) {
            if (child.isLeaf()) {
                res.add(path);
                continue;
            }
            this.findDevices(child, path + "." + child.toString(), res);
        }
    }

    List<String> getNodesList(String schemaPattern, int nodeLevel) throws SQLException {
        ArrayList<String> res = new ArrayList<String>();
        String[] nodes = MetaUtils.getNodeNames(schemaPattern, PATH_SEPARATOR);
        MNode node = this.getRoot();
        if (node != null) {
            if (nodes[0].equals("root")) {
                for (int i = 1; i < nodes.length; ++i) {
                    if (node.getChild(nodes[i]) == null) {
                        throw new SQLException(nodes[i - 1] + " does not have the child node " + nodes[i]);
                    }
                    node = node.getChild(nodes[i]);
                }
                this.findNodes(node, schemaPattern, res, nodeLevel - (nodes.length - 1));
            } else {
                throw new SQLException("Incorrect root node " + nodes[0] + " selected");
            }
        }
        return res;
    }

    private void findNodes(MNode node, String path, List<String> res, int targetLevel) {
        if (node == null) {
            return;
        }
        if (targetLevel == 0) {
            res.add(path);
            return;
        }
        if (node.hasChildren()) {
            for (MNode child : node.getChildren().values()) {
                this.findNodes(child, path + "." + child.toString(), res, targetLevel - 1);
            }
        }
    }

    ArrayList<String> getDeviceForOneType(String type) throws PathException {
        String path = this.getRoot().getName() + "." + type;
        this.getNode(path);
        HashMap<String, Integer> deviceMap = new HashMap<String, Integer>();
        MNode typeNode = this.getRoot().getChild(type);
        this.putDeviceToMap(this.getRoot().getName(), typeNode, deviceMap);
        return new ArrayList<String>(deviceMap.keySet());
    }

    private void putDeviceToMap(String path, MNode node, HashMap<String, Integer> deviceMap) {
        if (node.isLeaf()) {
            deviceMap.put(path, 1);
        } else {
            for (String child : node.getChildren().keySet()) {
                String newPath = path + "." + node.getName();
                this.putDeviceToMap(newPath, node.getChildren().get(child), deviceMap);
            }
        }
    }

    ArrayList<MeasurementSchema> getSchemaForOneType(String path) throws PathException {
        String[] nodes = MetaUtils.getNodeNames(path, PATH_SEPARATOR);
        if (nodes.length != 2 || !nodes[0].equals(this.getRoot().getName()) || !this.getRoot().hasChild(nodes[1])) {
            throw new MTreePathException("Timeseries must be " + this.getRoot().getName() + ". X (X is one of the nodes of root's children)");
        }
        HashMap<String, MeasurementSchema> leafMap = new HashMap<String, MeasurementSchema>();
        this.putLeafToLeafMap(this.getRoot().getChild(nodes[1]), leafMap);
        return new ArrayList<MeasurementSchema>(leafMap.values());
    }

    ArrayList<MeasurementSchema> getSchemaForOneStorageGroup(String path) {
        String[] nodes = MetaUtils.getNodeNames(path, PATH_SEPARATOR);
        HashMap<String, MeasurementSchema> leafMap = new HashMap<String, MeasurementSchema>();
        MNode cur = this.getRoot();
        for (int i = 1; i < nodes.length; ++i) {
            cur = cur.getChild(nodes[i]);
        }
        this.putLeafToLeafMap(cur, leafMap);
        return new ArrayList<MeasurementSchema>(leafMap.values());
    }

    Map<String, MeasurementSchema> getSchemaMapForOneStorageGroup(String path) {
        String[] nodes = MetaUtils.getNodeNames(path, PATH_SEPARATOR);
        MNode cur = this.getRoot();
        for (int i = 1; i < nodes.length; ++i) {
            cur = cur.getChild(nodes[i]);
        }
        return cur.getSchemaMap();
    }

    Map<String, Integer> getNumSchemaMapForOneFileNode(String path) {
        String[] nodes = MetaUtils.getNodeNames(path, PATH_SEPARATOR);
        MNode cur = this.getRoot();
        for (int i = 1; i < nodes.length; ++i) {
            cur = cur.getChild(nodes[i]);
        }
        return cur.getNumSchemaMap();
    }

    private void putLeafToLeafMap(MNode node, HashMap<String, MeasurementSchema> leafMap) {
        if (node.isLeaf()) {
            if (!leafMap.containsKey(node.getName())) {
                leafMap.put(node.getName(), node.getSchema());
            }
            return;
        }
        for (MNode child : node.getChildren().values()) {
            this.putLeafToLeafMap(child, leafMap);
        }
    }

    private void findPath(MNode node, String[] nodes, int idx, String parent, HashMap<String, List<String>> paths) {
        if (node.isLeaf()) {
            if (nodes.length <= idx) {
                String fileName = node.getDataFileName();
                String nodeName = node.getName().contains(".") ? "\"" + node + "\"" : "" + node;
                String nodePath = parent + nodeName;
                this.putAPath(paths, fileName, nodePath);
            }
            return;
        }
        String nodeReg = idx >= nodes.length ? "*" : nodes[idx];
        if (!"*".equals(nodeReg)) {
            if (node.hasChild(nodeReg)) {
                this.findPath(node.getChild(nodeReg), nodes, idx + 1, parent + node.getName() + ".", paths);
            }
        } else {
            for (MNode child : node.getChildren().values()) {
                this.findPath(child, nodes, idx + 1, parent + node.getName() + ".", paths);
            }
        }
    }

    private void findPath(MNode node, String[] nodes, int idx, String parent, List<List<String>> res) {
        if (node.isLeaf()) {
            if (nodes.length <= idx) {
                String nodePath = parent + node;
                ArrayList<String> tsRow = new ArrayList<String>(4);
                tsRow.add(nodePath);
                MeasurementSchema measurementSchema = node.getSchema();
                tsRow.add(node.getDataFileName());
                tsRow.add(measurementSchema.getType().toString());
                tsRow.add(measurementSchema.getEncodingType().toString());
                res.add(tsRow);
            }
            return;
        }
        String nodeReg = idx >= nodes.length ? "*" : nodes[idx];
        if (!"*".equals(nodeReg)) {
            if (node.hasChild(nodeReg)) {
                this.findPath(node.getChild(nodeReg), nodes, idx + 1, parent + node.getName() + ".", res);
            }
        } else {
            for (MNode child : node.getChildren().values()) {
                this.findPath(child, nodes, idx + 1, parent + node.getName() + ".", res);
            }
        }
    }

    private void putAPath(HashMap<String, List<String>> paths, String fileName, String nodePath) {
        if (paths.containsKey(fileName)) {
            paths.get(fileName).add(nodePath);
        } else {
            ArrayList<String> pathList = new ArrayList<String>();
            pathList.add(nodePath);
            paths.put(fileName, pathList);
        }
    }

    public String toString() {
        return MTree.jsonToString(this.toJson());
    }

    private static String jsonToString(JSONObject jsonObject) {
        return JSON.toJSONString((Object)jsonObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
    }

    private JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(this.getRoot().getName(), (Object)this.mNodeToJSON(this.getRoot()));
        return jsonObject;
    }

    private JSONObject mNodeToJSON(MNode node) {
        JSONObject jsonObject = new JSONObject();
        if (!node.isLeaf() && node.getChildren().size() > 0) {
            for (MNode child : node.getChildren().values()) {
                jsonObject.put(child.getName(), (Object)this.mNodeToJSON(child));
            }
        } else if (node.isLeaf()) {
            jsonObject.put("DataType", (Object)node.getSchema().getType());
            jsonObject.put("Encoding", (Object)node.getSchema().getEncodingType());
            jsonObject.put("Compressor", (Object)node.getSchema().getCompressor());
            jsonObject.put("args", (Object)node.getSchema().getProps().toString());
            jsonObject.put("StorageGroup", (Object)node.getDataFileName());
        }
        return jsonObject;
    }

    public MNode getRoot() {
        return this.root;
    }

    static String combineMetadataInStrings(String[] metadataStrs) {
        JSONObject[] jsonObjects = new JSONObject[metadataStrs.length];
        for (int i = 0; i < jsonObjects.length; ++i) {
            jsonObjects[i] = JSONObject.parseObject((String)metadataStrs[i]);
        }
        JSONObject root = jsonObjects[0];
        for (int i = 1; i < jsonObjects.length; ++i) {
            root = MTree.combineJSONObjects(root, jsonObjects[i]);
        }
        return MTree.jsonToString(root);
    }

    private static JSONObject combineJSONObjects(JSONObject a, JSONObject b) {
        JSONObject res = new JSONObject();
        HashSet retainSet = new HashSet(a.keySet());
        retainSet.retainAll(b.keySet());
        HashSet aCha = new HashSet(a.keySet());
        HashSet bCha = new HashSet(b.keySet());
        aCha.removeAll(retainSet);
        bCha.removeAll(retainSet);
        for (String key : aCha) {
            res.put(key, (Object)a.getJSONObject(key));
        }
        for (String key : bCha) {
            res.put(key, b.get((Object)key));
        }
        for (String key : retainSet) {
            Object v1 = a.get((Object)key);
            Object v2 = b.get((Object)key);
            if (v1 instanceof JSONObject && v2 instanceof JSONObject) {
                res.put(key, (Object)MTree.combineJSONObjects((JSONObject)v1, (JSONObject)v2));
                continue;
            }
            res.put(key, v1);
        }
        return res;
    }
}

