/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.path.MTreePathException;
import org.apache.iotdb.db.exception.path.PathException;
import org.apache.iotdb.db.exception.storageGroup.StorageGroupException;
import org.apache.iotdb.db.metadata.MNode;
import org.apache.iotdb.db.metadata.MTree;
import org.apache.iotdb.db.metadata.MetaUtils;
import org.apache.iotdb.db.metadata.Metadata;
import org.apache.iotdb.db.metadata.PTree;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class MGraph
implements Serializable {
    private static final long serialVersionUID = 8214849219614352834L;
    private static final String DOUB_SEPARATOR = "\\.";
    private MTree mtree;
    private HashMap<String, PTree> ptreeMap;

    MGraph(String mtreeName) {
        this.mtree = new MTree(mtreeName);
        this.ptreeMap = new HashMap();
    }

    void addAPTree(String ptreeRootName) throws MetadataException {
        if ("root".equalsIgnoreCase(ptreeRootName)) {
            throw new MetadataException("Property Tree's root name should not be 'root'");
        }
        PTree ptree = new PTree(ptreeRootName, this.mtree);
        this.ptreeMap.put(ptreeRootName, ptree);
    }

    public void addPathToMTree(String path, String dataType, String encoding) throws PathException {
        TSDataType tsDataType = TSDataType.valueOf((String)dataType);
        TSEncoding tsEncoding = TSEncoding.valueOf((String)encoding);
        CompressionType compressionType = CompressionType.valueOf((String)TSFileDescriptor.getInstance().getConfig().getCompressor());
        this.addPathToMTree(path, tsDataType, tsEncoding, compressionType, Collections.emptyMap());
    }

    public void addPathToMTree(String path, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props) throws PathException {
        String[] nodes = MetaUtils.getNodeNames(path, DOUB_SEPARATOR);
        if (nodes.length == 0) {
            throw new PathException();
        }
        this.mtree.addTimeseriesPath(path, dataType, encoding, compressor, props);
    }

    MNode addDeviceIdToMTree(String deviceId) throws PathException {
        return this.mtree.addDeviceId(deviceId);
    }

    void addPathToPTree(String path) throws PathException {
        String[] nodes = MetaUtils.getNodeNames(path, DOUB_SEPARATOR);
        if (nodes.length == 0) {
            throw new PathException();
        }
        String rootName = nodes[0];
        if (!this.ptreeMap.containsKey(rootName)) {
            throw new MTreePathException("Timeseries's root", rootName);
        }
        PTree ptree = this.ptreeMap.get(rootName);
        ptree.addPath(path);
    }

    String deletePath(String path) throws PathException {
        String[] nodes = MetaUtils.getNodeNames(path, DOUB_SEPARATOR);
        if (nodes.length == 0) {
            throw new PathException();
        }
        String rootName = nodes[0];
        if (this.mtree.getRoot().getName().equals(rootName)) {
            return this.mtree.deletePath(path);
        }
        if (this.ptreeMap.containsKey(rootName)) {
            PTree ptree = this.ptreeMap.get(rootName);
            ptree.deletePath(path);
            return null;
        }
        throw new MTreePathException("Timeseries's root", rootName);
    }

    void linkMNodeToPTree(String path, String mpath) throws PathException {
        String ptreeName = MetaUtils.getNodeNames(path, DOUB_SEPARATOR)[0];
        if (!this.ptreeMap.containsKey(ptreeName)) {
            throw new MTreePathException("PTree Path", path);
        }
        this.ptreeMap.get(ptreeName).linkMNode(path, mpath);
    }

    void unlinkMNodeFromPTree(String path, String mpath) throws PathException {
        String ptreeName = MetaUtils.getNodeNames(path, DOUB_SEPARATOR)[0];
        if (!this.ptreeMap.containsKey(ptreeName)) {
            throw new MTreePathException("PTree Path", path);
        }
        this.ptreeMap.get(ptreeName).unlinkMNode(path, mpath);
    }

    void setStorageGroup(String path) throws StorageGroupException {
        this.mtree.setStorageGroup(path);
    }

    void deleteStorageGroup(String path) throws PathException {
        this.mtree.deleteStorageGroup(path);
    }

    boolean checkStorageGroup(String path) {
        return this.mtree.checkStorageGroup(path);
    }

    HashMap<String, List<String>> getAllPathGroupByStorageGroup(String path) throws PathException {
        String rootName = MetaUtils.getNodeNames(path, DOUB_SEPARATOR)[0];
        if (this.mtree.getRoot().getName().equals(rootName)) {
            return this.mtree.getAllPath(path);
        }
        if (this.ptreeMap.containsKey(rootName)) {
            PTree ptree = this.ptreeMap.get(rootName);
            return ptree.getAllLinkedPath(path);
        }
        throw new MTreePathException("Timeseries's root", rootName);
    }

    List<MNode> getAllStorageGroupNodes() {
        return this.mtree.getAllStorageGroupNodes();
    }

    List<List<String>> getShowTimeseriesPath(String path) throws PathException {
        String rootName = MetaUtils.getNodeNames(path, DOUB_SEPARATOR)[0];
        if (this.mtree.getRoot().getName().equals(rootName)) {
            return this.mtree.getShowTimeseriesPath(path);
        }
        if (this.ptreeMap.containsKey(rootName)) {
            throw new PathException("PTree is not involved in the execution of the sql 'show timeseries " + path + "'");
        }
        throw new MTreePathException("Timeseries's root", rootName);
    }

    Map<String, List<MeasurementSchema>> getSchemaForAllType() throws PathException {
        HashMap<String, List<MeasurementSchema>> res = new HashMap<String, List<MeasurementSchema>>();
        ArrayList<String> typeList = this.mtree.getAllType();
        for (String type : typeList) {
            res.put(type, this.getSchemaForOneType("root." + type));
        }
        return res;
    }

    private ArrayList<String> getDeviceForOneType(String type) throws PathException {
        return this.mtree.getDeviceForOneType(type);
    }

    private Map<String, List<String>> getDeviceForAllType() throws PathException {
        HashMap<String, List<String>> res = new HashMap<String, List<String>>();
        ArrayList<String> types = this.mtree.getAllType();
        for (String type : types) {
            res.put(type, this.getDeviceForOneType(type));
        }
        return res;
    }

    public Metadata getMetadata() throws PathException {
        Map<String, List<String>> deviceIdMap = this.getDeviceForAllType();
        return new Metadata(deviceIdMap);
    }

    List<String> getAllStorageGroupNames() {
        return this.mtree.getAllStorageGroupList();
    }

    Set<String> getAllDevices() throws SQLException {
        return this.mtree.getAllDevices();
    }

    List<String> getNodesList(String schemaPattern, int nodeLevel) throws SQLException {
        return this.mtree.getNodesList(schemaPattern, nodeLevel);
    }

    List<String> getLeafNodePathInNextLevel(String path) throws PathException {
        return this.mtree.getLeafNodePathInNextLevel(path);
    }

    Set<String> getChildNodePathInNextLevel(String path) throws PathException {
        return this.mtree.getChildNodePathInNextLevel(path);
    }

    ArrayList<MeasurementSchema> getSchemaForOneType(String path) throws PathException {
        return this.mtree.getSchemaForOneType(path);
    }

    ArrayList<MeasurementSchema> getSchemaInOneStorageGroup(String path) {
        return this.mtree.getSchemaForOneStorageGroup(path);
    }

    Map<String, MeasurementSchema> getSchemaMapForOneFileNode(String path) {
        return this.mtree.getSchemaMapForOneStorageGroup(path);
    }

    Map<String, Integer> getNumSchemaMapForOneFileNode(String path) {
        return this.mtree.getNumSchemaMapForOneFileNode(path);
    }

    int getFileCountForOneType(String path) throws PathException {
        return this.mtree.getFileCountForOneType(path);
    }

    String getStorageGroupNameByPath(String path) throws StorageGroupException {
        return this.mtree.getStorageGroupNameByPath(path);
    }

    String getStorageGroupNameByPath(MNode node, String path) throws StorageGroupException {
        return this.mtree.getStorageGroupNameByPath(node, path);
    }

    boolean checkStorageGroupByPath(String path) {
        return this.mtree.checkFileNameByPath(path);
    }

    List<String> getAllStorageGroupNamesByPath(String path) throws PathException {
        return this.mtree.getAllFileNamesByPath(path);
    }

    boolean pathExist(String path) {
        return this.mtree.isPathExist(path);
    }

    boolean pathExist(MNode node, String path) {
        return this.mtree.isPathExist(node, path);
    }

    MNode getNodeByPath(String path) throws PathException {
        return this.mtree.getNode(path);
    }

    MNode getNodeByPathWithCheck(String path) throws PathException, StorageGroupException {
        return this.mtree.getNodeByPathWithStorageGroupCheck(path);
    }

    MeasurementSchema getSchemaForOnePath(String path) throws PathException {
        return this.mtree.getSchemaForOnePath(path);
    }

    MeasurementSchema getSchemaForOnePath(MNode node, String path) throws PathException {
        return this.mtree.getSchemaForOnePath(node, path);
    }

    MeasurementSchema getSchemaForOnePathWithCheck(MNode node, String path) throws PathException {
        return this.mtree.getSchemaForOnePathWithCheck(node, path);
    }

    MeasurementSchema getSchemaForOnePathWithCheck(String path) throws PathException {
        return this.mtree.getSchemaForOnePathWithCheck(path);
    }

    public String toString() {
        return this.mtree.toString();
    }

    static String combineMetadataInStrings(String[] metadataArray) {
        return MTree.combineMetadataInStrings(metadataArray);
    }

    Map<String, Integer> countSeriesNumberInEachStorageGroup() throws PathException {
        HashMap<String, Integer> res = new HashMap<String, Integer>();
        List<String> storageGroups = this.getAllStorageGroupNames();
        for (String sg : storageGroups) {
            MNode node = this.mtree.getNode(sg);
            res.put(sg, node.getLeafCount());
        }
        return res;
    }
}

