/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.querycontext.ReadOnlyMemChunk;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessor;
import org.apache.iotdb.db.engine.upgrade.UpgradeTask;
import org.apache.iotdb.db.service.UpgradeSevice;
import org.apache.iotdb.db.utils.UpgradeUtils;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetaData;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.fileSystem.fsFactory.FSFactory;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class TsFileResource {
    private File file;
    public static final String RESOURCE_SUFFIX = ".resource";
    static final String TEMP_SUFFIX = ".temp";
    private Map<String, Long> startTimeMap;
    private Map<String, Long> endTimeMap;
    private TsFileProcessor processor;
    private ModificationFile modFile;
    private volatile boolean closed = false;
    private volatile boolean deleted = false;
    private volatile boolean isMerging = false;
    private List<ChunkMetaData> chunkMetaDataList;
    private ReadOnlyMemChunk readOnlyMemChunk;
    private ReentrantReadWriteLock writeQueryLock = new ReentrantReadWriteLock();
    private FSFactory fsFactory = FSFactoryProducer.getFSFactory();

    public TsFileResource(File file) {
        this.file = file;
        this.startTimeMap = new ConcurrentHashMap<String, Long>();
        this.endTimeMap = new HashMap<String, Long>();
        this.closed = true;
    }

    public TsFileResource(File file, TsFileProcessor processor) {
        this.file = file;
        this.startTimeMap = new ConcurrentHashMap<String, Long>();
        this.endTimeMap = new ConcurrentHashMap<String, Long>();
        this.processor = processor;
    }

    public TsFileResource(File file, Map<String, Long> startTimeMap, Map<String, Long> endTimeMap) {
        this.file = file;
        this.startTimeMap = startTimeMap;
        this.endTimeMap = endTimeMap;
        this.closed = true;
    }

    public TsFileResource(File file, Map<String, Long> startTimeMap, Map<String, Long> endTimeMap, ReadOnlyMemChunk readOnlyMemChunk, List<ChunkMetaData> chunkMetaDataList) {
        this.file = file;
        this.startTimeMap = startTimeMap;
        this.endTimeMap = endTimeMap;
        this.chunkMetaDataList = chunkMetaDataList;
        this.readOnlyMemChunk = readOnlyMemChunk;
    }

    public void serialize() throws IOException {
        try (BufferedOutputStream outputStream = this.fsFactory.getBufferedOutputStream(this.file + RESOURCE_SUFFIX + TEMP_SUFFIX);){
            ReadWriteIOUtils.write((int)this.startTimeMap.size(), (OutputStream)outputStream);
            for (Map.Entry<String, Long> entry : this.startTimeMap.entrySet()) {
                ReadWriteIOUtils.write((String)entry.getKey(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((long)entry.getValue(), (OutputStream)outputStream);
            }
            ReadWriteIOUtils.write((int)this.endTimeMap.size(), (OutputStream)outputStream);
            for (Map.Entry<String, Long> entry : this.endTimeMap.entrySet()) {
                ReadWriteIOUtils.write((String)entry.getKey(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((long)entry.getValue(), (OutputStream)outputStream);
            }
        }
        File src = this.fsFactory.getFile(this.file + RESOURCE_SUFFIX + TEMP_SUFFIX);
        File dest = this.fsFactory.getFile(this.file + RESOURCE_SUFFIX);
        dest.delete();
        this.fsFactory.moveFile(src, dest);
    }

    public void deSerialize() throws IOException {
        try (BufferedInputStream inputStream = this.fsFactory.getBufferedInputStream(this.file + RESOURCE_SUFFIX);){
            int size = ReadWriteIOUtils.readInt((InputStream)inputStream);
            HashMap<String, Long> startTimes = new HashMap<String, Long>();
            for (int i = 0; i < size; ++i) {
                String path = ReadWriteIOUtils.readString((InputStream)inputStream);
                long time = ReadWriteIOUtils.readLong((InputStream)inputStream);
                startTimes.put(path, time);
            }
            size = ReadWriteIOUtils.readInt((InputStream)inputStream);
            HashMap<String, Long> endTimes = new HashMap<String, Long>();
            for (int i = 0; i < size; ++i) {
                String path = ReadWriteIOUtils.readString((InputStream)inputStream);
                long time = ReadWriteIOUtils.readLong((InputStream)inputStream);
                endTimes.put(path, time);
            }
            this.startTimeMap = startTimes;
            this.endTimeMap = endTimes;
        }
    }

    public void updateStartTime(String device, long time) {
        long startTime = this.startTimeMap.getOrDefault(device, Long.MAX_VALUE);
        if (time < startTime) {
            this.startTimeMap.put(device, time);
        }
    }

    public void updateEndTime(String device, long time) {
        long endTime = this.endTimeMap.getOrDefault(device, Long.MIN_VALUE);
        if (time > endTime) {
            this.endTimeMap.put(device, time);
        }
    }

    public boolean fileExists() {
        return this.fsFactory.getFile(this.file + RESOURCE_SUFFIX).exists();
    }

    public void forceUpdateEndTime(String device, long time) {
        this.endTimeMap.put(device, time);
    }

    public List<ChunkMetaData> getChunkMetaDataList() {
        return this.chunkMetaDataList;
    }

    public ReadOnlyMemChunk getReadOnlyMemChunk() {
        return this.readOnlyMemChunk;
    }

    public synchronized ModificationFile getModFile() {
        if (this.modFile == null) {
            this.modFile = new ModificationFile(this.file.getAbsolutePath() + ".mods");
        }
        return this.modFile;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public boolean containsDevice(String deviceId) {
        return this.startTimeMap.containsKey(deviceId);
    }

    public File getFile() {
        return this.file;
    }

    public long getFileSize() {
        return this.file.length();
    }

    public Map<String, Long> getStartTimeMap() {
        return this.startTimeMap;
    }

    public Map<String, Long> getEndTimeMap() {
        return this.endTimeMap;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() throws IOException {
        this.closed = true;
        if (this.modFile != null) {
            this.modFile.close();
            this.modFile = null;
        }
        this.processor = null;
        this.chunkMetaDataList = null;
    }

    public TsFileProcessor getUnsealedFileProcessor() {
        return this.processor;
    }

    public ReentrantReadWriteLock getWriteQueryLock() {
        return this.writeQueryLock;
    }

    public void doUpgrade() {
        if (UpgradeUtils.isNeedUpgrade(this)) {
            UpgradeSevice.getINSTANCE().submitUpgradeTask(new UpgradeTask(this));
        }
    }

    public void removeModFile() throws IOException {
        this.getModFile().remove();
        this.modFile = null;
    }

    public void remove() {
        this.file.delete();
        this.fsFactory.getFile(this.file.getPath() + RESOURCE_SUFFIX).delete();
        this.fsFactory.getFile(this.file.getPath() + ".mods").delete();
    }

    public String toString() {
        return this.file.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TsFileResource that = (TsFileResource)o;
        return Objects.equals(this.file, that.file);
    }

    public int hashCode() {
        return Objects.hash(this.file);
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean isMerging() {
        return this.isMerging;
    }

    public void setMerging(boolean merging) {
        this.isMerging = merging;
    }

    public boolean stillLives(long timeLowerBound) {
        if (timeLowerBound == Long.MAX_VALUE) {
            return true;
        }
        for (long endTime : this.endTimeMap.values()) {
            if (endTime < timeLowerBound) continue;
            return true;
        }
        return false;
    }
}

