/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.cache;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.cache.LRULinkedHashMap;
import org.apache.iotdb.db.engine.cache.RamUsageEstimator;
import org.apache.iotdb.db.engine.cache.TsFileMetadataUtils;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.tsfile.file.metadata.TsFileMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileMetaDataCache {
    private static final Logger logger = LoggerFactory.getLogger(TsFileMetaDataCache.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static boolean cacheEnable = config.isMetaDataCacheEnable();
    private static final long MEMORY_THRESHOLD_IN_B = config.getAllocateMemoryForFileMetaDataCache();
    private LRULinkedHashMap<TsFileResource, TsFileMetaData> cache;
    private AtomicLong cacheHitNum = new AtomicLong();
    private AtomicLong cacheRequestNum = new AtomicLong();
    private long deviceIndexMapEntrySize = 0L;
    private long measurementSchemaEntrySize = 0L;
    private long versionAndCreatebySize = 10L;

    private TsFileMetaDataCache() {
        this.cache = new LRULinkedHashMap<TsFileResource, TsFileMetaData>(MEMORY_THRESHOLD_IN_B, true){

            @Override
            protected long calEntrySize(TsFileResource key, TsFileMetaData value) {
                if (TsFileMetaDataCache.this.deviceIndexMapEntrySize == 0L && value.getDeviceMap().size() > 0) {
                    TsFileMetaDataCache.this.deviceIndexMapEntrySize = RamUsageEstimator.sizeOf(value.getDeviceMap().entrySet().iterator().next());
                }
                if (TsFileMetaDataCache.this.measurementSchemaEntrySize == 0L && value.getMeasurementSchema().size() > 0) {
                    TsFileMetaDataCache.this.measurementSchemaEntrySize = RamUsageEstimator.sizeOf(value.getMeasurementSchema().entrySet().iterator().next());
                }
                long valueSize = (long)value.getDeviceMap().size() * TsFileMetaDataCache.this.deviceIndexMapEntrySize + TsFileMetaDataCache.this.measurementSchemaEntrySize * (long)value.getMeasurementSchema().size() + TsFileMetaDataCache.this.versionAndCreatebySize;
                return (long)(key.getFile().getPath().length() * 2) + valueSize;
            }
        };
    }

    public static TsFileMetaDataCache getInstance() {
        return TsFileMetaDataCacheHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TsFileMetaData get(TsFileResource tsFileResource) throws IOException {
        if (!cacheEnable) {
            return TsFileMetadataUtils.getTsFileMetaData(tsFileResource);
        }
        String path = tsFileResource.getFile().getPath();
        String internPath = path.intern();
        this.cacheRequestNum.incrementAndGet();
        Object object = this.cache;
        synchronized (object) {
            if (this.cache.containsKey(path)) {
                this.cacheHitNum.incrementAndGet();
                this.printCacheLog(true);
                return (TsFileMetaData)this.cache.get(path);
            }
        }
        object = internPath;
        synchronized (object) {
            LRULinkedHashMap<TsFileResource, TsFileMetaData> lRULinkedHashMap = this.cache;
            synchronized (lRULinkedHashMap) {
                if (this.cache.containsKey(path)) {
                    this.cacheHitNum.incrementAndGet();
                    this.printCacheLog(true);
                    return (TsFileMetaData)this.cache.get(path);
                }
            }
            this.printCacheLog(false);
            TsFileMetaData fileMetaData = TsFileMetadataUtils.getTsFileMetaData(tsFileResource);
            LRULinkedHashMap<TsFileResource, TsFileMetaData> lRULinkedHashMap2 = this.cache;
            synchronized (lRULinkedHashMap2) {
                this.cache.put(tsFileResource, fileMetaData);
                return fileMetaData;
            }
        }
    }

    private void printCacheLog(boolean isHit) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        if (isHit) {
            logger.debug("[TsFileMetaData cache hit] The number of requests for cache is {}, hit rate is {}.", (Object)this.cacheRequestNum.get(), (Object)((double)this.cacheHitNum.get() * 1.0 / (double)this.cacheRequestNum.get()));
        } else {
            logger.debug("[TsFileMetaData cache didn't hit] The number of requests for cache is {}, hit rate is {}.", (Object)this.cacheRequestNum.get(), (Object)((double)this.cacheHitNum.get() * 1.0 / (double)this.cacheRequestNum.get()));
        }
    }

    public double calculateTsfileMetaDataHitRatio() {
        if (this.cacheRequestNum.get() != 0L) {
            return (double)this.cacheHitNum.get() * 1.0 / (double)this.cacheRequestNum.get();
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(TsFileResource resource) {
        LRULinkedHashMap<TsFileResource, TsFileMetaData> lRULinkedHashMap = this.cache;
        synchronized (lRULinkedHashMap) {
            if (this.cache != null) {
                this.cache.remove(resource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LRULinkedHashMap<TsFileResource, TsFileMetaData> lRULinkedHashMap = this.cache;
        synchronized (lRULinkedHashMap) {
            if (this.cache != null) {
                this.cache.clear();
            }
        }
    }

    private static class TsFileMetaDataCacheHolder {
        private static final TsFileMetaDataCache INSTANCE = new TsFileMetaDataCache();

        private TsFileMetaDataCacheHolder() {
        }
    }
}

