/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.cache;

import java.util.LinkedHashMap;
import java.util.Map;

public abstract class LRULinkedHashMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 1290160928914532649L;
    private static final float LOAD_FACTOR_MAP = 0.75f;
    private static final int INITIAL_CAPACITY = 128;
    private long maxMemInB;
    private long usedMemInB;

    public LRULinkedHashMap(long maxMemInB, boolean isLru) {
        super(128, 0.75f, isLru);
        this.maxMemInB = maxMemInB;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        if (this.usedMemInB > this.maxMemInB) {
            this.usedMemInB -= this.calEntrySize(eldest.getKey(), eldest.getValue());
            return true;
        }
        return false;
    }

    @Override
    public V put(K key, V value) {
        this.usedMemInB += this.calEntrySize(key, value);
        return super.put(key, value);
    }

    protected abstract long calEntrySize(K var1, V var2);

    public double getUsedMemoryProportion() {
        return (double)this.usedMemInB * 1.0 / (double)this.maxMemInB;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

