/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf.adapter;

import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.adapter.CompressionRatio;
import org.apache.iotdb.db.conf.adapter.IDynamicAdapter;
import org.apache.iotdb.db.exception.ConfigAdjusterException;
import org.apache.iotdb.db.metadata.MManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBConfigDynamicAdapter
implements IDynamicAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBConfigDynamicAdapter.class);
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private static long allocateMemoryForWrite = CONFIG.getAllocateMemoryForWrite();
    private static final long TIMESERIES_METADATA_SIZE_IN_BYTE = 2048L;
    private static final long CHUNK_METADATA_SIZE_IN_BYTE = 1536L;
    static final int MEM_TABLE_AVERAGE_QUEUE_LEN = 5;
    private long staticMemory;
    private int totalStorageGroup;
    private int totalTimeseries;
    private int maxMemTableNum = 5;
    private long currentMemTableSize;
    private boolean initialized = false;

    @Override
    public synchronized boolean tryToAdaptParameters() {
        boolean canAdjust = true;
        double ratio = CompressionRatio.getInstance().getRatio();
        long memtableSizeInByte = this.calcMemTableSize(ratio);
        long memTableSizeFloorThreshold = this.getMemTableSizeFloorThreshold();
        long tsFileSizeThreshold = CONFIG.getTsFileSizeThreshold();
        if (memtableSizeInByte < memTableSizeFloorThreshold) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("memtableSizeInByte {} is smaller than memTableSizeFloorThreshold {}", (Object)memtableSizeInByte, (Object)memTableSizeFloorThreshold);
            }
            if ((long)((double)(tsFileSizeThreshold = this.calcTsFileSizeThreshold(memTableSizeFloorThreshold, ratio)) * ratio) < memTableSizeFloorThreshold) {
                canAdjust = false;
            } else {
                memtableSizeInByte = Math.max(memTableSizeFloorThreshold, memTableSizeFloorThreshold + ((long)((double)tsFileSizeThreshold * ratio) - memTableSizeFloorThreshold >> 1));
            }
        }
        if (canAdjust) {
            CONFIG.setMaxMemtableNumber(this.maxMemTableNum);
            CONFIG.setTsFileSizeThreshold(tsFileSizeThreshold);
            CONFIG.setMemtableSizeThreshold(memtableSizeInByte);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("After adjusting, max memTable num is {}, tsFile threshold is {}, memtableSize is {}, memTableSizeFloorThreshold is {}, storage group = {}, total timeseries = {}, the max number of timeseries among storage groups = {}", new Object[]{this.maxMemTableNum, tsFileSizeThreshold, memtableSizeInByte, memTableSizeFloorThreshold, this.totalStorageGroup, this.totalTimeseries, MManager.getInstance().getMaximalSeriesNumberAmongStorageGroups()});
            }
            this.currentMemTableSize = memtableSizeInByte;
        }
        if (!this.initialized) {
            CONFIG.setMaxMemtableNumber(this.maxMemTableNum);
            return true;
        }
        return canAdjust;
    }

    private int calcMemTableSize(double ratio) {
        double a = this.maxMemTableNum;
        double b = allocateMemoryForWrite - this.staticMemory;
        int magnification = b > 2.147483647E9 ? 1024 : 1;
        double c = (double)CONFIG.getTsFileSizeThreshold() * (double)this.maxMemTableNum * 1536.0 * (double)MManager.getInstance().getMaximalSeriesNumberAmongStorageGroups() * ratio / (double)magnification / (double)magnification;
        double tempValue = (b /= (double)magnification) * b - 4.0 * a * c;
        double memTableSize = (b + Math.sqrt(tempValue)) / (2.0 * a);
        return tempValue < 0.0 ? -1 : (int)(memTableSize * (double)magnification);
    }

    private long calcTsFileSizeThreshold(long memTableSize, double ratio) {
        return (long)((double)((allocateMemoryForWrite - (long)this.maxMemTableNum * memTableSize - this.staticMemory) * memTableSize) / (ratio * (double)this.maxMemTableNum * 1536.0 * (double)MManager.getInstance().getMaximalSeriesNumberAmongStorageGroups()));
    }

    private long getMemTableSizeFloorThreshold() {
        return MManager.getInstance().getMaximalSeriesNumberAmongStorageGroups() * 128L * 8L * 2L;
    }

    @Override
    public void addOrDeleteStorageGroup(int diff) throws ConfigAdjusterException {
        this.totalStorageGroup += diff;
        this.maxMemTableNum += 4 * diff;
        if (!CONFIG.isEnableParameterAdapter()) {
            CONFIG.setMaxMemtableNumber(this.maxMemTableNum);
            return;
        }
        if (!this.tryToAdaptParameters()) {
            this.totalStorageGroup -= diff;
            this.maxMemTableNum -= 4 * diff;
            throw new ConfigAdjusterException("create storage group");
        }
    }

    @Override
    public void addOrDeleteTimeSeries(int diff) throws ConfigAdjusterException {
        if (!CONFIG.isEnableParameterAdapter()) {
            return;
        }
        this.totalTimeseries += diff;
        this.staticMemory += (long)diff * 2048L;
        if (!this.tryToAdaptParameters()) {
            this.totalTimeseries -= diff;
            this.staticMemory -= (long)diff * 2048L;
            throw new ConfigAdjusterException("add timeseries");
        }
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    long getCurrentMemTableSize() {
        return this.currentMemTableSize;
    }

    public int getTotalTimeseries() {
        return this.totalTimeseries;
    }

    public int getTotalStorageGroup() {
        return this.totalStorageGroup;
    }

    public void reset() {
        this.totalTimeseries = 0;
        this.staticMemory = 0L;
        this.maxMemTableNum = 5;
        allocateMemoryForWrite = CONFIG.getAllocateMemoryForWrite();
        this.initialized = false;
    }

    private IoTDBConfigDynamicAdapter() {
    }

    public static IoTDBConfigDynamicAdapter getInstance() {
        return IoTDBConfigAdapterHolder.INSTANCE;
    }

    private static class IoTDBConfigAdapterHolder {
        private static final IoTDBConfigDynamicAdapter INSTANCE = new IoTDBConfigDynamicAdapter();

        private IoTDBConfigAdapterHolder() {
        }
    }
}

