/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.jdbc;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.jdbc.IoTDBMetadataResultMetadata;
import org.apache.iotdb.jdbc.IoTDBQueryResultSet;

public class IoTDBMetadataResultSet
extends IoTDBQueryResultSet {
    private static final String GET_STRING_COLUMN = "COLUMN";
    private static final String GET_STRING_STORAGE_GROUP = "STORAGE_GROUP";
    private static final String GET_STRING_TIMESERIES_NUM = "TIMESERIES_NUM";
    private static final String GET_STRING_NODES_NUM = "NODE_NUM";
    private static final String GET_STRING_NODE_PATH = "NODE_PATH";
    private static final String GET_STRING_NODE_TIMESERIES_NUM = "NODE_TIMESERIES_NUM";
    private static final String GET_STRING_TIMESERIES_NAME = "Timeseries";
    private static final String GET_STRING_DEVICES = "DEVICES";
    private static final String GET_STRING_TIMESERIES_STORAGE_GROUP = "Storage Group";
    private static final String GET_STRING_CHILD_PATHS = "Child Paths";
    public static final String GET_STRING_TIMESERIES_DATATYPE = "DataType";
    private static final String GET_STRING_TIMESERIES_ENCODING = "Encoding";
    private Iterator<?> columnItr;
    private MetadataType type;
    private String currentColumn;
    private String currentStorageGroup;
    private String currentDevice;
    private String currentChildPath;
    private String currentVersion;
    private List<String> currentTimeseries;
    private List<String> timeseriesNumList;
    private List<String> nodesNumList;
    private Map<String, String> nodeTimeseriesNumMap;
    private String timeseriesNum;
    private String nodesNum;
    private String currentNode;
    private String currentNodeTimeseriesNum;
    private int colCount;
    private String[] showLabels;
    private static final String METHOD_NOT_SUPPORTED = "Method not supported";

    IoTDBMetadataResultSet(Object object, MetadataType type) throws SQLException {
        this.type = type;
        switch (type) {
            case COLUMN: {
                List columns = (List)object;
                this.colCount = 1;
                this.showLabels = new String[]{"column"};
                this.columnItr = columns.iterator();
                break;
            }
            case STORAGE_GROUP: {
                Set storageGroupSet = (Set)object;
                this.colCount = 1;
                this.showLabels = new String[]{GET_STRING_TIMESERIES_STORAGE_GROUP};
                this.columnItr = storageGroupSet.iterator();
                break;
            }
            case DEVICES: {
                Set devicesSet = (Set)object;
                this.colCount = 1;
                this.showLabels = new String[]{"Device"};
                this.columnItr = devicesSet.iterator();
                break;
            }
            case CHILD_PATHS: {
                Set childPathsSet = (Set)object;
                this.colCount = 1;
                this.showLabels = new String[]{GET_STRING_CHILD_PATHS};
                this.columnItr = childPathsSet.iterator();
                break;
            }
            case TIMESERIES: {
                List showTimeseriesList = (List)object;
                this.colCount = 4;
                this.showLabels = new String[]{GET_STRING_TIMESERIES_NAME, GET_STRING_TIMESERIES_STORAGE_GROUP, GET_STRING_TIMESERIES_DATATYPE, GET_STRING_TIMESERIES_ENCODING};
                this.columnItr = showTimeseriesList.iterator();
                break;
            }
            case COUNT_TIMESERIES: {
                String tsNum = object.toString();
                this.timeseriesNumList = new ArrayList<String>();
                this.timeseriesNumList.add(tsNum);
                this.colCount = 1;
                this.showLabels = new String[]{"count"};
                this.columnItr = this.timeseriesNumList.iterator();
                break;
            }
            case COUNT_NODES: {
                String ndNum = object.toString();
                this.nodesNumList = new ArrayList<String>();
                this.nodesNumList.add(ndNum);
                this.colCount = 1;
                this.showLabels = new String[]{"count"};
                this.columnItr = this.nodesNumList.iterator();
                break;
            }
            case COUNT_NODE_TIMESERIES: {
                this.nodeTimeseriesNumMap = (Map)object;
                this.colCount = 2;
                this.showLabels = new String[]{"column", "count"};
                this.columnItr = this.nodeTimeseriesNumMap.entrySet().iterator();
                break;
            }
            case VERSION: {
                String version = (String)object;
                this.colCount = 1;
                this.showLabels = new String[]{version};
                HashSet<String> versionSet = new HashSet<String>();
                versionSet.add(version);
                this.columnItr = versionSet.iterator();
                break;
            }
            default: {
                throw new SQLException("TsfileMetadataResultSet constructor is wrongly used.");
            }
        }
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public int getConcurrency() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return new IoTDBMetadataResultMetadata(this.showLabels);
    }

    @Override
    public boolean next() {
        boolean hasNext = this.columnItr.hasNext();
        if (hasNext) {
            switch (this.type) {
                case STORAGE_GROUP: {
                    this.currentStorageGroup = (String)this.columnItr.next();
                    break;
                }
                case TIMESERIES: {
                    this.currentTimeseries = (List)this.columnItr.next();
                    break;
                }
                case COLUMN: {
                    this.currentColumn = (String)this.columnItr.next();
                    break;
                }
                case DEVICES: {
                    this.currentDevice = (String)this.columnItr.next();
                    break;
                }
                case CHILD_PATHS: {
                    this.currentChildPath = (String)this.columnItr.next();
                    break;
                }
                case COUNT_TIMESERIES: {
                    this.timeseriesNum = (String)this.columnItr.next();
                    break;
                }
                case COUNT_NODES: {
                    this.nodesNum = (String)this.columnItr.next();
                    break;
                }
                case COUNT_NODE_TIMESERIES: {
                    Map.Entry pair = (Map.Entry)this.columnItr.next();
                    this.currentNode = (String)pair.getKey();
                    this.currentNodeTimeseriesNum = (String)pair.getValue();
                    break;
                }
                case VERSION: {
                    this.currentVersion = (String)this.columnItr.next();
                    hasNext = false;
                    break;
                }
            }
        }
        return hasNext;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public Statement getStatement() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        switch (this.type) {
            case STORAGE_GROUP: {
                if (columnIndex != 1) break;
                return this.getString(GET_STRING_STORAGE_GROUP);
            }
            case TIMESERIES: {
                if (columnIndex < 1 || columnIndex > this.colCount) break;
                return this.getString(this.showLabels[columnIndex - 1]);
            }
            case COLUMN: {
                if (columnIndex != 1) break;
                return this.getString(GET_STRING_COLUMN);
            }
            case DEVICES: {
                if (columnIndex == 1) {
                    return this.getString(GET_STRING_DEVICES);
                }
            }
            case CHILD_PATHS: {
                if (columnIndex == 1) {
                    return this.getString(GET_STRING_CHILD_PATHS);
                }
            }
            case COUNT_TIMESERIES: {
                if (columnIndex != 1) break;
                return this.getString(GET_STRING_TIMESERIES_NUM);
            }
            case COUNT_NODES: {
                if (columnIndex == 1) {
                    return this.getString(GET_STRING_NODES_NUM);
                }
            }
            case COUNT_NODE_TIMESERIES: {
                return columnIndex == 1 ? this.getString(GET_STRING_NODE_PATH) : this.getString(GET_STRING_NODE_TIMESERIES_NUM);
            }
        }
        throw new SQLException(String.format("select column index %d does not exists", columnIndex));
    }

    @Override
    public String getString(String columnName) {
        switch (columnName) {
            case "STORAGE_GROUP": {
                return this.currentStorageGroup;
            }
            case "Timeseries": {
                return this.currentTimeseries.get(0);
            }
            case "Storage Group": {
                return this.currentTimeseries.get(1);
            }
            case "DataType": {
                return this.currentTimeseries.get(2);
            }
            case "Encoding": {
                return this.currentTimeseries.get(3);
            }
            case "COLUMN": {
                return this.currentColumn;
            }
            case "DEVICES": {
                return this.currentDevice;
            }
            case "Child Paths": {
                return this.currentChildPath;
            }
            case "TIMESERIES_NUM": {
                return this.timeseriesNum;
            }
            case "NODE_NUM": {
                return this.nodesNum;
            }
            case "NODE_PATH": {
                return this.currentNode;
            }
            case "NODE_TIMESERIES_NUM": {
                return this.currentNodeTimeseriesNum;
            }
        }
        return null;
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public int getType() {
        return this.type.ordinal();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public boolean wasNull() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    public static enum MetadataType {
        STORAGE_GROUP,
        TIMESERIES,
        COLUMN,
        DEVICES,
        CHILD_PATHS,
        COUNT_TIMESERIES,
        COUNT_NODES,
        COUNT_NODE_TIMESERIES,
        VERSION;

    }
}

