/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.jdbc;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.iotdb.jdbc.IoTDBConnectionParams;
import org.apache.iotdb.jdbc.IoTDBSQLException;
import org.apache.iotdb.jdbc.IoTDBURLException;
import org.apache.iotdb.service.rpc.thrift.TSDataValue;
import org.apache.iotdb.service.rpc.thrift.TSQueryDataSet;
import org.apache.iotdb.service.rpc.thrift.TSRowRecord;
import org.apache.iotdb.service.rpc.thrift.TS_Status;
import org.apache.iotdb.service.rpc.thrift.TS_StatusCode;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.utils.Binary;

public class Utils {
    private Utils() {
        throw new IllegalAccessError("Utility class");
    }

    public static IoTDBConnectionParams parseUrl(String url, Properties info) throws IoTDBURLException {
        IoTDBConnectionParams params = new IoTDBConnectionParams(url);
        if (url.trim().equalsIgnoreCase("jdbc:iotdb://")) {
            return params;
        }
        Pattern pattern = Pattern.compile("([^;]*):([^;]*)/");
        Matcher matcher = pattern.matcher(url.substring("jdbc:iotdb://".length()));
        boolean isUrlLegal = false;
        while (matcher.find()) {
            params.setHost(matcher.group(1));
            params.setPort(Integer.parseInt(matcher.group(2)));
            isUrlLegal = true;
        }
        if (!isUrlLegal) {
            throw new IoTDBURLException("Error url format, url should be jdbc:iotdb://ip:port/");
        }
        if (info.containsKey("user")) {
            params.setUsername(info.getProperty("user"));
        }
        if (info.containsKey("password")) {
            params.setPassword(info.getProperty("password"));
        }
        return params;
    }

    public static void verifySuccess(TS_Status status) throws IoTDBSQLException {
        if (status.getStatusCode() != TS_StatusCode.SUCCESS_STATUS) {
            throw new IoTDBSQLException(status.errorMessage);
        }
    }

    public static List<RowRecord> convertRowRecords(TSQueryDataSet tsQueryDataSet) {
        ArrayList<RowRecord> records = new ArrayList<RowRecord>();
        for (TSRowRecord ts : tsQueryDataSet.getRecords()) {
            RowRecord r = new RowRecord(ts.getTimestamp());
            int l = ts.getValuesSize();
            for (int i = 0; i < l; ++i) {
                TSDataValue value = (TSDataValue)ts.getValues().get(i);
                if (value.is_empty) {
                    Field field = new Field(null);
                    field.setNull();
                    r.getFields().add(field);
                    continue;
                }
                TSDataType dataType = TSDataType.valueOf((String)value.getType());
                Field field = new Field(dataType);
                Utils.addFieldAccordingToDataType(field, dataType, value);
                r.getFields().add(field);
            }
            records.add(r);
        }
        return records;
    }

    private static void addFieldAccordingToDataType(Field field, TSDataType dataType, TSDataValue value) {
        switch (dataType) {
            case BOOLEAN: {
                field.setBoolV(value.isBool_val());
                break;
            }
            case INT32: {
                field.setIntV(value.getInt_val());
                break;
            }
            case INT64: {
                field.setLongV(value.getLong_val());
                break;
            }
            case FLOAT: {
                field.setFloatV((float)value.getFloat_val());
                break;
            }
            case DOUBLE: {
                field.setDoubleV(value.getDouble_val());
                break;
            }
            case TEXT: {
                field.setBinaryV(new Binary(value.getBinary_val()));
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("data type %s is not supported when convert data at client", dataType));
            }
        }
    }
}

