/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.jdbc.IoTDBConnection;
import org.apache.iotdb.jdbc.IoTDBStatement;
import org.apache.iotdb.service.rpc.thrift.TSIService;
import org.apache.iotdb.service.rpc.thrift.TS_SessionHandle;

public class IoTDBPreparedStatement
extends IoTDBStatement
implements PreparedStatement {
    private String sql;
    private static final String METHOD_NOT_SUPPORTED_STRING = "Method not supported";
    private final Map<Integer, String> parameters = new HashMap<Integer, String>();

    public IoTDBPreparedStatement(IoTDBConnection connection, TSIService.Iface client, TS_SessionHandle sessionHandle, ZoneId zoneId) throws SQLException {
        super(connection, client, sessionHandle, zoneId);
        this.requestStmtId();
    }

    public IoTDBPreparedStatement(IoTDBConnection connection, TSIService.Iface client, TS_SessionHandle sessionHandle, String sql, ZoneId zoneId) {
        super(connection, client, sessionHandle, zoneId);
        this.sql = sql;
    }

    @Override
    public void addBatch() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.parameters.clear();
    }

    @Override
    public boolean execute() throws SQLException {
        return super.execute(this.createCompleteSql(this.sql, this.parameters));
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return super.executeQuery(this.createCompleteSql(this.sql, this.parameters));
    }

    @Override
    public int executeUpdate() throws SQLException {
        return super.executeUpdate(this.createCompleteSql(this.sql, this.parameters));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.parameters.put(parameterIndex, Boolean.toString(x));
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.parameters.put(parameterIndex, Double.toString(x));
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.parameters.put(parameterIndex, Float.toString(x));
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.parameters.put(parameterIndex, Integer.toString(x));
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.parameters.put(parameterIndex, Long.toString(x));
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (x instanceof String) {
            this.setString(parameterIndex, (String)x);
        } else if (x instanceof Integer) {
            this.setInt(parameterIndex, (Integer)x);
        } else if (x instanceof Long) {
            this.setLong(parameterIndex, (Long)x);
        } else if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
        } else if (x instanceof Double) {
            this.setDouble(parameterIndex, (Double)x);
        } else if (x instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else {
            throw new SQLException(String.format("Can''t infer the SQL type to use for an instance of %s. Use setObject() with an explicit Types value to specify the type to use.", x.getClass().getName()));
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.parameters.put(parameterIndex, "'" + x.replace("'", "\\'") + "'");
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(x.getTime()), this.zoneId);
        this.parameters.put(parameterIndex, zonedDateTime.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED_STRING);
    }

    private String createCompleteSql(String sql, Map<Integer, String> parameters) throws SQLException {
        List<String> parts = this.splitSqlStatement(sql);
        StringBuilder newSql = new StringBuilder(parts.get(0));
        for (int i = 1; i < parts.size(); ++i) {
            if (!parameters.containsKey(i)) {
                throw new SQLException("Parameter #" + i + " is unset");
            }
            newSql.append(parameters.get(i));
            newSql.append(parts.get(i));
        }
        return newSql.toString();
    }

    private List<String> splitSqlStatement(String sql) {
        ArrayList<String> parts = new ArrayList<String>();
        int apCount = 0;
        int off = 0;
        boolean skip = false;
        block5: for (int i = 0; i < sql.length(); ++i) {
            char c = sql.charAt(i);
            if (skip) {
                skip = false;
                continue;
            }
            switch (c) {
                case '\'': {
                    ++apCount;
                    continue block5;
                }
                case '\\': {
                    skip = true;
                    continue block5;
                }
                case '?': {
                    if ((apCount & 1) != 0) continue block5;
                    parts.add(sql.substring(off, i));
                    off = i + 1;
                    continue block5;
                }
            }
        }
        parts.add(sql.substring(off, sql.length()));
        return parts;
    }
}

