/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.jdbc;

import java.sql.SQLException;
import java.time.ZoneId;
import java.util.List;
import org.apache.iotdb.jdbc.IoTDBConnection;
import org.apache.iotdb.jdbc.IoTDBPreparedStatement;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementResp;
import org.apache.iotdb.service.rpc.thrift.TSIService;
import org.apache.iotdb.service.rpc.thrift.TSInsertionReq;
import org.apache.iotdb.service.rpc.thrift.TS_SessionHandle;
import org.apache.iotdb.service.rpc.thrift.TS_StatusCode;
import org.apache.thrift.TException;

public class IoTDBPreparedInsertionStatement
extends IoTDBPreparedStatement {
    private TSInsertionReq req = new TSInsertionReq();

    public IoTDBPreparedInsertionStatement(IoTDBConnection connection, TSIService.Iface client, TS_SessionHandle sessionHandle, ZoneId zoneId) throws SQLException {
        super(connection, client, sessionHandle, zoneId);
        this.req.setStmtId(this.stmtId);
    }

    @Override
    public boolean execute() throws SQLException {
        try {
            TSExecuteStatementResp resp = this.client.executeInsertion(this.req);
            this.req.unsetDeviceId();
            this.req.unsetMeasurements();
            this.req.unsetTimestamp();
            this.req.unsetValues();
            return resp.getStatus().getStatusCode() == TS_StatusCode.SUCCESS_STATUS;
        }
        catch (TException e) {
            throw new SQLException(e);
        }
    }

    public void setTimestamp(long timestamp) {
        this.req.setTimestamp(timestamp);
    }

    public void setDeviceId(String deviceId) {
        this.req.setDeviceId(deviceId);
    }

    public void setMeasurements(List<String> measurements) {
        this.req.setMeasurements(measurements);
    }

    public void setValues(List<String> values) {
        this.req.setValues(values);
    }
}

