/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cli.client;

import java.io.IOException;
import java.sql.DriverManager;
import java.sql.SQLException;
import jline.console.ConsoleReader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.iotdb.cli.client.AbstractClient;
import org.apache.iotdb.cli.exception.ArgsErrorException;
import org.apache.iotdb.jdbc.IoTDBConnection;
import org.apache.thrift.TException;

public class Client
extends AbstractClient {
    private static CommandLine commandLine;

    public static void main(String[] args) throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        Options options = Client.createOptions();
        HelpFormatter hf = new HelpFormatter();
        hf.setWidth(88);
        commandLine = null;
        if (args == null || args.length == 0) {
            Client.println("Require more params input, eg. ./start-client.sh(start-client.bat if Windows) -h xxx.xxx.xxx.xxx -p xxxx -u xxx.");
            Client.println("For more information, please check the following hint.");
            hf.printHelp("./start-client.sh(start-client.bat if Windows)", options, true);
            return;
        }
        Client.init();
        String[] newArgs = Client.removePasswordArgs(args);
        boolean continues = Client.parseCommandLine(options, newArgs, hf);
        if (!continues) {
            return;
        }
        Client.serve();
    }

    private static boolean parseCommandLine(Options options, String[] newArgs, HelpFormatter hf) {
        try {
            DefaultParser parser = new DefaultParser();
            commandLine = parser.parse(options, newArgs);
            if (commandLine.hasOption("help")) {
                hf.printHelp("./start-client.sh(start-client.bat if Windows)", options, true);
                return false;
            }
            if (commandLine.hasOption("disableISO8601")) {
                Client.setTimeFormat("long");
            }
            if (commandLine.hasOption("maxPRC")) {
                Client.setMaxDisplayNumber(commandLine.getOptionValue("maxPRC"));
            }
        }
        catch (ParseException e) {
            Client.println("Require more params input, eg. ./start-client.sh(start-client.bat if Windows) -h xxx.xxx.xxx.xxx -p xxxx -u xxx.");
            Client.println("For more information, please check the following hint.");
            hf.printHelp("IoTDB", options, true);
            Client.handleException((Exception)((Object)e));
            return false;
        }
        catch (NumberFormatException e) {
            Client.println("IoTDB> error format of max print row count, it should be number");
            Client.handleException(e);
            return false;
        }
        return true;
    }

    private static void serve() {
        try (ConsoleReader reader = new ConsoleReader();){
            reader.setExpandEvents(false);
            host = Client.checkRequiredArg("h", "host", commandLine, false, host);
            port = Client.checkRequiredArg("p", "port", commandLine, false, port);
            username = Client.checkRequiredArg("u", "username", commandLine, true, null);
            password = commandLine.getOptionValue("pw");
            if (password == null) {
                password = reader.readLine("please input your password:", Character.valueOf('\u0000'));
            }
            Client.receiveCommands(reader);
        }
        catch (ArgsErrorException e) {
            Client.println("IoTDB> input params error because" + e.getMessage());
            Client.handleException(e);
        }
        catch (Exception e) {
            Client.println("IoTDB> exit client with error " + e.getMessage());
            Client.handleException(e);
        }
    }

    private static void receiveCommands(ConsoleReader reader) throws TException, IOException {
        try (IoTDBConnection connection = (IoTDBConnection)DriverManager.getConnection("jdbc:iotdb://" + host + ":" + port + "/", username, password);){
            String s;
            boolean continues;
            properties = connection.getServerProperties();
            AGGREGRATE_TIME_LIST.addAll(properties.getSupportedTimeAggregationOperations());
            Client.displayLogo(properties.getVersion());
            Client.println("IoTDB> login successfully");
            while (continues = Client.processCmd(s = reader.readLine("IoTDB> ", null), connection)) {
            }
        }
        catch (SQLException e) {
            Client.println(String.format("%s> %s Host is %s, port is %s.", "IoTDB", e.getMessage(), host, port));
            Client.handleException(e);
        }
    }

    private static boolean processCmd(String s, IoTDBConnection connection) {
        if (s == null) {
            return true;
        }
        String[] cmds = s.trim().split(";");
        block4: for (int i = 0; i < cmds.length; ++i) {
            String cmd = cmds[i];
            if (cmd == null || "".equals(cmd.trim())) continue;
            AbstractClient.OperationResult result = Client.handleInputCmd(cmd, connection);
            switch (result) {
                case STOP_OPER: {
                    return false;
                }
                case CONTINUE_OPER: {
                    continue block4;
                }
            }
        }
        return true;
    }
}

