/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.rescon.PrimitiveArrayPool;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class LongTVList
extends TVList {
    private List<long[]> values = new ArrayList<long[]>();
    private long[][] sortedValues;
    private long pivotValue;

    LongTVList() {
    }

    @Override
    public void putLong(long timestamp, long value) {
        this.checkExpansion();
        int arrayIndex = this.size / 128;
        int elementIndex = this.size % 128;
        this.minTime = this.minTime <= timestamp ? this.minTime : timestamp;
        ((long[])this.timestamps.get((int)arrayIndex))[elementIndex] = timestamp;
        this.values.get((int)arrayIndex)[elementIndex] = value;
        ++this.size;
        if (this.sorted && this.size > 1 && timestamp < this.getTime(this.size - 2)) {
            this.sorted = false;
        }
    }

    @Override
    public long getLong(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int arrayIndex = index / 128;
        int elementIndex = index % 128;
        return this.values.get(arrayIndex)[elementIndex];
    }

    protected void set(int index, long timestamp, long value) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int arrayIndex = index / 128;
        int elementIndex = index % 128;
        ((long[])this.timestamps.get((int)arrayIndex))[elementIndex] = timestamp;
        this.values.get((int)arrayIndex)[elementIndex] = value;
    }

    @Override
    public LongTVList clone() {
        LongTVList cloneList = new LongTVList();
        this.cloneAs(cloneList);
        for (long[] valueArray : this.values) {
            cloneList.values.add(this.cloneValue(valueArray));
        }
        return cloneList;
    }

    private long[] cloneValue(long[] array) {
        long[] cloneArray = new long[array.length];
        System.arraycopy(array, 0, cloneArray, 0, array.length);
        return cloneArray;
    }

    @Override
    public void sort() {
        if (this.sortedTimestamps == null || this.sortedTimestamps.length < this.size) {
            this.sortedTimestamps = (long[][])PrimitiveArrayPool.getInstance().getDataListsByType(TSDataType.INT64, this.size);
        }
        if (this.sortedValues == null || this.sortedValues.length < this.size) {
            this.sortedValues = (long[][])PrimitiveArrayPool.getInstance().getDataListsByType(TSDataType.INT64, this.size);
        }
        this.sort(0, this.size);
        this.clearSortedValue();
        this.clearSortedTime();
        this.sorted = true;
    }

    @Override
    void clearValue() {
        if (this.values != null) {
            for (long[] dataArray : this.values) {
                PrimitiveArrayPool.getInstance().release(dataArray);
            }
            this.values.clear();
        }
    }

    @Override
    void clearSortedValue() {
        if (this.sortedValues != null) {
            for (long[] dataArray : this.sortedValues) {
                PrimitiveArrayPool.getInstance().release(dataArray);
            }
            this.sortedValues = null;
        }
    }

    @Override
    protected void setFromSorted(int src, int dest) {
        this.set(dest, this.sortedTimestamps[src / 128][src % 128], this.sortedValues[src / 128][src % 128]);
    }

    @Override
    protected void set(int src, int dest) {
        long srcT = this.getTime(src);
        long srcV = this.getLong(src);
        this.set(dest, srcT, srcV);
    }

    @Override
    protected void setToSorted(int src, int dest) {
        this.sortedTimestamps[dest / 128][dest % 128] = this.getTime(src);
        this.sortedValues[dest / 128][dest % 128] = this.getLong(src);
    }

    @Override
    protected void reverseRange(int lo, int hi) {
        --hi;
        while (lo < hi) {
            long loT = this.getTime(lo);
            long loV = this.getLong(lo);
            long hiT = this.getTime(hi);
            long hiV = this.getLong(hi);
            this.set(lo++, hiT, hiV);
            this.set(hi--, loT, loV);
        }
    }

    @Override
    protected void expandValues() {
        this.values.add((long[])PrimitiveArrayPool.getInstance().getPrimitiveDataListByType(TSDataType.INT64));
    }

    @Override
    protected void saveAsPivot(int pos) {
        this.pivotTime = this.getTime(pos);
        this.pivotValue = this.getLong(pos);
    }

    @Override
    protected void setPivotTo(int pos) {
        this.set(pos, this.pivotTime, this.pivotValue);
    }

    @Override
    protected void releaseLastValueArray() {
        PrimitiveArrayPool.getInstance().release(this.values.remove(this.values.size() - 1));
    }
}

