/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import org.apache.iotdb.db.query.aggregation.AggreResultData;
import org.apache.iotdb.db.utils.TimeValuePair;
import org.apache.iotdb.db.utils.TsPrimitiveType;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.read.common.BatchData;

public class TimeValuePairUtils {
    private TimeValuePairUtils() {
    }

    public static TimeValuePair getCurrentTimeValuePair(BatchData data) {
        switch (data.getDataType()) {
            case INT32: {
                return new TimeValuePair(data.currentTime(), new TsPrimitiveType.TsInt(data.getInt()));
            }
            case INT64: {
                return new TimeValuePair(data.currentTime(), new TsPrimitiveType.TsLong(data.getLong()));
            }
            case FLOAT: {
                return new TimeValuePair(data.currentTime(), new TsPrimitiveType.TsFloat(data.getFloat()));
            }
            case DOUBLE: {
                return new TimeValuePair(data.currentTime(), new TsPrimitiveType.TsDouble(data.getDouble()));
            }
            case TEXT: {
                return new TimeValuePair(data.currentTime(), new TsPrimitiveType.TsBinary(data.getBinary()));
            }
            case BOOLEAN: {
                return new TimeValuePair(data.currentTime(), new TsPrimitiveType.TsBoolean(data.getBoolean()));
            }
        }
        throw new UnSupportedDataTypeException(String.valueOf(data.getDataType()));
    }

    public static TimeValuePair getCurrentTimeValuePair(AggreResultData data) {
        switch (data.getDataType()) {
            case INT32: {
                return new TimeValuePair(data.getTimestamp(), new TsPrimitiveType.TsInt(data.getIntRet()));
            }
            case INT64: {
                return new TimeValuePair(data.getTimestamp(), new TsPrimitiveType.TsLong(data.getLongRet()));
            }
            case FLOAT: {
                return new TimeValuePair(data.getTimestamp(), new TsPrimitiveType.TsFloat(data.getFloatRet()));
            }
            case DOUBLE: {
                return new TimeValuePair(data.getTimestamp(), new TsPrimitiveType.TsDouble(data.getDoubleRet()));
            }
            case TEXT: {
                return new TimeValuePair(data.getTimestamp(), new TsPrimitiveType.TsBinary(data.getBinaryRet()));
            }
            case BOOLEAN: {
                return new TimeValuePair(data.getTimestamp(), new TsPrimitiveType.TsBoolean(data.isBooleanRet()));
            }
        }
        throw new UnSupportedDataTypeException(String.valueOf(data.getDataType()));
    }
}

