/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.io.File;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.sync.conf.SyncSenderDescriptor;

public class SyncUtils {
    private static final String IP_SEPARATOR = "\\.";
    private static String[] snapshotPaths = SyncSenderDescriptor.getInstance().getConfig().getSnapshotPaths();

    private SyncUtils() {
    }

    public static String getSnapshotFilePath(String filePath) {
        String relativeFilePath;
        String[] name;
        String os = System.getProperty("os.name");
        if (os.toLowerCase().startsWith("windows")) {
            name = filePath.split(File.separator + File.separator);
            relativeFilePath = name[name.length - 2] + File.separator + name[name.length - 1];
        } else {
            name = filePath.split(File.separator);
            relativeFilePath = name[name.length - 2] + File.separator + name[name.length - 1];
        }
        String bufferWritePath = name[0];
        for (int i = 1; i < name.length - 2; ++i) {
            bufferWritePath = bufferWritePath + File.separatorChar + name[i];
        }
        for (String snapshotPath : snapshotPaths) {
            if (!snapshotPath.startsWith(bufferWritePath)) continue;
            if (!new File(snapshotPath).exists()) {
                new File(snapshotPath).mkdir();
            }
            if (snapshotPath.length() > 0 && snapshotPath.charAt(snapshotPath.length() - 1) != File.separatorChar) {
                snapshotPath = snapshotPath + File.separatorChar;
            }
            return snapshotPath + relativeFilePath;
        }
        return null;
    }

    public static boolean isEmpty(Map<String, Set<String>> sendingFileList) {
        for (Map.Entry<String, Set<String>> entry : sendingFileList.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static boolean verifyIPSegment(String ipWhiteList, String ipAddress) {
        String[] ipSegments;
        for (String IPsegment : ipSegments = ipWhiteList.split(",")) {
            int subnetMask = Integer.parseInt(IPsegment.substring(IPsegment.indexOf(47) + 1));
            if (!SyncUtils.verifyIP(IPsegment = IPsegment.substring(0, IPsegment.indexOf(47)), ipAddress, subnetMask)) continue;
            return true;
        }
        return false;
    }

    private static boolean verifyIP(String ipSegment, String ipAddress, int subnetMark) {
        String[] ipSplits = ipSegment.split(IP_SEPARATOR);
        DecimalFormat df = new DecimalFormat("00000000");
        StringBuilder ipSegmentBuilder = new StringBuilder();
        for (String IPsplit : ipSplits) {
            ipSegmentBuilder.append(df.format(Integer.parseInt(Integer.toBinaryString(Integer.parseInt(IPsplit)))));
        }
        String ipSegmentBinary = ipSegmentBuilder.toString();
        ipSegmentBinary = ipSegmentBinary.substring(0, subnetMark);
        ipSplits = ipAddress.split(IP_SEPARATOR);
        StringBuilder ipAddressBuilder = new StringBuilder();
        for (String IPsplit : ipSplits) {
            ipAddressBuilder.append(df.format(Integer.parseInt(Integer.toBinaryString(Integer.parseInt(IPsplit)))));
        }
        String ipAddressBinary = ipAddressBuilder.toString();
        ipAddressBinary = ipAddressBinary.substring(0, subnetMark);
        return ipAddressBinary.equals(ipSegmentBinary);
    }
}

