/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.service.rpc.thrift.TSDataValue;
import org.apache.iotdb.service.rpc.thrift.TSQueryDataSet;
import org.apache.iotdb.service.rpc.thrift.TSRowRecord;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;

public class QueryDataSetUtils {
    private QueryDataSetUtils() {
    }

    public static TSQueryDataSet convertQueryDataSetByFetchSize(QueryDataSet queryDataSet, int fetchSize) throws IOException {
        TSQueryDataSet tsQueryDataSet = new TSQueryDataSet();
        tsQueryDataSet.setRecords(new ArrayList());
        for (int i = 0; i < fetchSize && queryDataSet.hasNext(); ++i) {
            RowRecord rowRecord = queryDataSet.next();
            tsQueryDataSet.getRecords().add(QueryDataSetUtils.convertToTSRecord(rowRecord));
        }
        return tsQueryDataSet;
    }

    private static TSRowRecord convertToTSRecord(RowRecord rowRecord) {
        TSRowRecord tsRowRecord = new TSRowRecord();
        tsRowRecord.setTimestamp(rowRecord.getTimestamp());
        tsRowRecord.setValues(new ArrayList());
        List fields = rowRecord.getFields();
        for (Field f : fields) {
            TSDataValue value = new TSDataValue(false);
            if (f.getDataType() == null) {
                value.setIs_empty(true);
            } else {
                switch (f.getDataType()) {
                    case BOOLEAN: {
                        value.setBool_val(f.getBoolV());
                        break;
                    }
                    case INT32: {
                        value.setInt_val(f.getIntV());
                        break;
                    }
                    case INT64: {
                        value.setLong_val(f.getLongV());
                        break;
                    }
                    case FLOAT: {
                        value.setFloat_val((double)f.getFloatV());
                        break;
                    }
                    case DOUBLE: {
                        value.setDouble_val(f.getDoubleV());
                        break;
                    }
                    case TEXT: {
                        value.setBinary_val(ByteBuffer.wrap(f.getBinaryV().getValues()));
                        break;
                    }
                    default: {
                        throw new UnSupportedDataTypeException(String.format("data type %s is not supported when convert data at server", f.getDataType().toString()));
                    }
                }
                value.setType(f.getDataType().toString());
            }
            tsRowRecord.getValues().add(value);
        }
        return tsRowRecord;
    }
}

