/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.conf;

import java.io.File;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.utils.FilePathUtils;

public class SyncSenderConfig {
    private String[] seqFileDirectory = IoTDBDescriptor.getInstance().getConfig().getDataDirs();
    private String dataDirectory = IoTDBDescriptor.getInstance().getConfig().getBaseDir();
    private String lockFilePath;
    private String uuidPath;
    private String lastFileInfo;
    private String[] snapshotPaths;
    private String schemaPath;
    private String serverIp = "127.0.0.1";
    private int serverPort = 5555;
    private int syncPeriodInSecond = 10;

    public void init() {
        this.schemaPath = IoTDBDescriptor.getInstance().getConfig().getSystemDir() + File.separator + "mlog.txt";
        if (this.dataDirectory.length() > 0 && this.dataDirectory.charAt(this.dataDirectory.length() - 1) != File.separatorChar) {
            this.dataDirectory = this.dataDirectory + File.separatorChar;
        }
        this.lockFilePath = this.dataDirectory + "sync-client" + File.separatorChar + "sync-lock";
        this.uuidPath = this.dataDirectory + "sync-client" + File.separatorChar + "uuid.txt";
        this.lastFileInfo = this.dataDirectory + "sync-client" + File.separatorChar + "last_local_files.txt";
        this.snapshotPaths = new String[this.seqFileDirectory.length];
        for (int i = 0; i < this.seqFileDirectory.length; ++i) {
            this.seqFileDirectory[i] = new File(this.seqFileDirectory[i]).getAbsolutePath();
            this.seqFileDirectory[i] = FilePathUtils.regularizePath(this.seqFileDirectory[i]);
            this.snapshotPaths[i] = this.seqFileDirectory[i] + "sync-client" + File.separatorChar + "data-snapshot" + File.separatorChar;
        }
    }

    public String[] getSeqFileDirectory() {
        return this.seqFileDirectory;
    }

    public void setSeqFileDirectory(String[] seqFileDirectory) {
        this.seqFileDirectory = seqFileDirectory;
    }

    public String getDataDirectory() {
        return this.dataDirectory;
    }

    public void setDataDirectory(String dataDirectory) {
        this.dataDirectory = dataDirectory;
    }

    public String getUuidPath() {
        return this.uuidPath;
    }

    public void setUuidPath(String uuidPath) {
        this.uuidPath = uuidPath;
    }

    public String getLastFileInfo() {
        return this.lastFileInfo;
    }

    public void setLastFileInfo(String lastFileInfo) {
        this.lastFileInfo = lastFileInfo;
    }

    public String[] getSnapshotPaths() {
        return this.snapshotPaths;
    }

    public void setSnapshotPaths(String[] snapshotPaths) {
        this.snapshotPaths = snapshotPaths;
    }

    public String getSchemaPath() {
        return this.schemaPath;
    }

    public void setSchemaPath(String schemaPath) {
        this.schemaPath = schemaPath;
    }

    public String getServerIp() {
        return this.serverIp;
    }

    public void setServerIp(String serverIp) {
        this.serverIp = serverIp;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public int getSyncPeriodInSecond() {
        return this.syncPeriodInSecond;
    }

    public void setSyncPeriodInSecond(int syncPeriodInSecond) {
        this.syncPeriodInSecond = syncPeriodInSecond;
    }

    public String getLockFilePath() {
        return this.lockFilePath;
    }

    public void setLockFilePath(String lockFilePath) {
        this.lockFilePath = lockFilePath;
    }
}

