/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sql.parse;

import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.BaseRecognizer;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenRewriteStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeAdaptor;
import org.antlr.runtime.tree.TreeAdaptor;
import org.apache.iotdb.db.sql.parse.AstErrorNode;
import org.apache.iotdb.db.sql.parse.AstNode;
import org.apache.iotdb.db.sql.parse.ParseError;
import org.apache.iotdb.db.sql.parse.ParseException;
import org.apache.iotdb.db.sql.parse.TSLexer;
import org.apache.iotdb.db.sql.parse.TSParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseDriver {
    public static final TreeAdaptor adaptor = new CommonTreeAdaptor(){

        public Object create(Token payload) {
            return new AstNode(payload);
        }

        public Object dupNode(Object t) {
            return this.create(((CommonTree)t).token);
        }

        public Object errorNode(TokenStream input, Token start, Token stop, RecognitionException e) {
            return new AstErrorNode(input, start, stop, e);
        }
    };
    private static final Logger LOG = LoggerFactory.getLogger((String)"ql.parse.ParseDriver");

    public AstNode parse(String command) throws ParseException {
        TSLexerX lexer = new TSLexerX((CharStream)new ANTLRNoCaseStringStream(command));
        TokenRewriteStream tokens = new TokenRewriteStream((TokenSource)lexer);
        TSParser parser = new TSParser((TokenStream)tokens);
        parser.setTreeAdaptor(adaptor);
        TSParser.statement_return r = null;
        try {
            r = parser.statement();
        }
        catch (RecognitionException e) {
            LOG.trace("meet error while parsing statement: {}", (Object)command, (Object)e);
        }
        if (!lexer.getErrors().isEmpty()) {
            throw new ParseException(lexer.getErrors());
        }
        if (!parser.errors.isEmpty()) {
            throw new ParseException(parser.errors);
        }
        if (r != null) {
            AstNode tree = (AstNode)r.getTree();
            tree.setUnknownTokenBoundaries();
            return tree;
        }
        return null;
    }

    public class TSLexerX
    extends TSLexer {
        private final ArrayList<ParseError> errors;

        public TSLexerX(CharStream input) {
            super(input);
            this.errors = new ArrayList();
        }

        public void displayRecognitionError(String[] tokenNames, RecognitionException e) {
            this.errors.add(new ParseError((BaseRecognizer)this, e, tokenNames));
        }

        public String getErrorMessage(RecognitionException e, String[] tokenNames) {
            String msg = e instanceof NoViableAltException ? "character " + this.getCharErrorDisplay(e.c) + " not supported here" : super.getErrorMessage(e, tokenNames);
            String input = e.input.toString();
            if (input.contains("timestamp") || input.contains("time")) {
                msg = msg + ". (Note that time format should be something like 1) number: eg.123456 2) function: eg.now() 3) datatime: eg.yyyy-MM-dd HH:mm:ss, please check whether inputting correct time format or referring to sql document)";
            }
            return msg;
        }

        public List<ParseError> getErrors() {
            return this.errors;
        }
    }

    public class ANTLRNoCaseStringStream
    extends ANTLRStringStream {
        public ANTLRNoCaseStringStream(String input) {
            super(input);
        }

        public int LA(int i) {
            int returnChar = super.LA(i);
            if (returnChar == -1 || returnChar == 0) {
                return returnChar;
            }
            return Character.toUpperCase((char)returnChar);
        }
    }
}

