/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.universal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.iotdb.db.query.reader.IPointReader;
import org.apache.iotdb.db.utils.TimeValuePair;

public class PriorityMergeReader
implements IPointReader {
    private List<IPointReader> readerList = new ArrayList<IPointReader>();
    private List<Integer> priorityList = new ArrayList<Integer>();
    private PriorityQueue<Element> heap = new PriorityQueue();

    public void addReaderWithPriority(IPointReader reader, int priority) throws IOException {
        if (reader.hasNext()) {
            this.heap.add(new Element(this.readerList.size(), reader.next(), priority));
        }
        this.readerList.add(reader);
        this.priorityList.add(priority);
    }

    @Override
    public boolean hasNext() {
        return !this.heap.isEmpty();
    }

    @Override
    public TimeValuePair next() throws IOException {
        Element top = this.heap.peek();
        this.updateHeap(top);
        return top.timeValuePair;
    }

    @Override
    public TimeValuePair current() {
        return this.heap.peek().timeValuePair;
    }

    private void updateHeap(Element top) throws IOException {
        while (!this.heap.isEmpty() && this.heap.peek().timeValuePair.getTimestamp() == top.timeValuePair.getTimestamp()) {
            Element e = this.heap.poll();
            IPointReader reader = this.readerList.get(e.index);
            if (!reader.hasNext()) continue;
            this.heap.add(new Element(e.index, reader.next(), this.priorityList.get(e.index)));
        }
    }

    @Override
    public void close() throws IOException {
        for (IPointReader reader : this.readerList) {
            reader.close();
        }
    }

    protected class Element
    implements Comparable<Element> {
        int index;
        TimeValuePair timeValuePair;
        Integer priority;

        public Element(int index, TimeValuePair timeValuePair, int priority) {
            this.index = index;
            this.timeValuePair = timeValuePair;
            this.priority = priority;
        }

        @Override
        public int compareTo(Element o) {
            if (this.timeValuePair.getTimestamp() > o.timeValuePair.getTimestamp()) {
                return 1;
            }
            if (this.timeValuePair.getTimestamp() < o.timeValuePair.getTimestamp()) {
                return -1;
            }
            return o.priority.compareTo(this.priority);
        }

        public boolean equals(Object o) {
            if (o instanceof Element) {
                Element element = (Element)o;
                if (this.timeValuePair.getTimestamp() == element.timeValuePair.getTimestamp() && this.priority.equals(element.priority)) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return (int)(this.timeValuePair.getTimestamp() * 31L + (long)this.priority.hashCode());
        }
    }
}

