/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.seriesRelated;

import java.io.IOException;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.reader.resourceRelated.SeqResourceReaderByTimestamp;
import org.apache.iotdb.db.query.reader.resourceRelated.UnseqResourceReaderByTimestamp;
import org.apache.iotdb.db.query.reader.universal.PriorityMergeReaderByTimestamp;
import org.apache.iotdb.tsfile.read.common.Path;

public class SeriesReaderByTimestamp
extends PriorityMergeReaderByTimestamp {
    public SeriesReaderByTimestamp(Path seriesPath, QueryContext context) throws StorageEngineException, IOException {
        QueryDataSource queryDataSource = QueryResourceManager.getInstance().getQueryDataSource(seriesPath, context);
        SeqResourceReaderByTimestamp seqResourceReaderByTimestamp = new SeqResourceReaderByTimestamp(seriesPath, queryDataSource.getSeqResources(), context);
        UnseqResourceReaderByTimestamp unseqResourceReaderByTimestamp = new UnseqResourceReaderByTimestamp(seriesPath, queryDataSource.getUnseqResources(), context);
        this.addReaderWithPriority(seqResourceReaderByTimestamp, 1);
        this.addReaderWithPriority(unseqResourceReaderByTimestamp, 2);
    }
}

