/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.resourceRelated;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.db.query.reader.chunkRelated.DiskChunkReader;
import org.apache.iotdb.db.query.reader.chunkRelated.MemChunkReader;
import org.apache.iotdb.db.query.reader.universal.PriorityMergeReader;
import org.apache.iotdb.db.utils.QueryUtils;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetaData;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.controller.ChunkLoaderImpl;
import org.apache.iotdb.tsfile.read.controller.MetadataQuerierByFileImpl;
import org.apache.iotdb.tsfile.read.filter.DigestForFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.reader.chunk.ChunkReader;
import org.apache.iotdb.tsfile.read.reader.chunk.ChunkReaderWithFilter;
import org.apache.iotdb.tsfile.read.reader.chunk.ChunkReaderWithoutFilter;

public class UnseqResourceMergeReader
extends PriorityMergeReader {
    private Path seriesPath;

    public UnseqResourceMergeReader(Path seriesPath, List<TsFileResource> unseqResources, QueryContext context, Filter filter) throws IOException {
        this.seriesPath = seriesPath;
        int priorityValue = 1;
        for (TsFileResource tsFileResource : unseqResources) {
            List metaDataList;
            TsFileSequenceReader tsFileReader;
            if (tsFileResource.isClosed()) {
                if (this.isTsFileNotSatisfied(tsFileResource, filter)) continue;
                tsFileReader = FileReaderManager.getInstance().get(tsFileResource.getFile().getPath(), true);
                MetadataQuerierByFileImpl metadataQuerier = new MetadataQuerierByFileImpl(tsFileReader);
                metaDataList = metadataQuerier.getChunkMetaDataList(seriesPath);
                List<Modification> pathModifications = context.getPathModifications(tsFileResource.getModFile(), seriesPath.getFullPath());
                if (!pathModifications.isEmpty()) {
                    QueryUtils.modifyChunkMetaData(metaDataList, pathModifications);
                }
            } else {
                if (tsFileResource.getEndTimeMap().size() != 0 && this.isTsFileNotSatisfied(tsFileResource, filter)) continue;
                tsFileReader = FileReaderManager.getInstance().get(tsFileResource.getFile().getPath(), false);
                metaDataList = tsFileResource.getChunkMetaDatas();
            }
            ChunkLoaderImpl chunkLoader = new ChunkLoaderImpl(tsFileReader);
            for (ChunkMetaData chunkMetaData : metaDataList) {
                DigestForFilter digest;
                if (filter != null && !filter.satisfy(digest = new DigestForFilter(chunkMetaData.getStartTime(), chunkMetaData.getEndTime(), (ByteBuffer)chunkMetaData.getDigest().getStatistics().get("min_value"), (ByteBuffer)chunkMetaData.getDigest().getStatistics().get("max_value"), chunkMetaData.getTsDataType()))) continue;
                Chunk chunk = chunkLoader.getChunk(chunkMetaData);
                ChunkReaderWithFilter chunkReader = filter != null ? new ChunkReaderWithFilter(chunk, filter) : new ChunkReaderWithoutFilter(chunk);
                this.addReaderWithPriority(new DiskChunkReader((ChunkReader)chunkReader), priorityValue++);
            }
            if (tsFileResource.isClosed()) continue;
            this.addReaderWithPriority(new MemChunkReader(tsFileResource.getReadOnlyMemChunk(), filter), priorityValue++);
        }
    }

    private boolean isTsFileNotSatisfied(TsFileResource tsFile, Filter filter) {
        long endTime;
        if (filter == null) {
            return false;
        }
        long startTime = tsFile.getStartTimeMap().get(this.seriesPath.getDevice());
        return !filter.satisfyStartEndTime(startTime, endTime = tsFile.getEndTimeMap().get(this.seriesPath.getDevice()).longValue());
    }
}

