/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.resourceRelated;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.db.query.reader.IAggregateReader;
import org.apache.iotdb.db.query.reader.fileRelated.FileSeriesReaderAdapter;
import org.apache.iotdb.db.query.reader.fileRelated.UnSealedTsFileIterateReader;
import org.apache.iotdb.db.query.reader.universal.IterateReader;
import org.apache.iotdb.db.utils.QueryUtils;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.controller.ChunkLoader;
import org.apache.iotdb.tsfile.read.controller.ChunkLoaderImpl;
import org.apache.iotdb.tsfile.read.controller.MetadataQuerierByFileImpl;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.reader.series.FileSeriesReader;
import org.apache.iotdb.tsfile.read.reader.series.FileSeriesReaderWithFilter;
import org.apache.iotdb.tsfile.read.reader.series.FileSeriesReaderWithoutFilter;

public class SeqResourceIterateReader
extends IterateReader {
    private Path seriesPath;
    private boolean enableReverse;
    private List<TsFileResource> seqResources;
    private Filter filter;
    private QueryContext context;

    public SeqResourceIterateReader(Path seriesPath, List<TsFileResource> seqResources, Filter filter, QueryContext context, boolean isReverse) {
        super(seqResources.size());
        this.seriesPath = seriesPath;
        this.enableReverse = isReverse;
        if (isReverse) {
            Collections.reverse(seqResources);
        }
        this.seqResources = seqResources;
        this.filter = filter;
        this.context = context;
    }

    public SeqResourceIterateReader(Path seriesPath, List<TsFileResource> seqResources, Filter timeFilter, QueryContext context) {
        this(seriesPath, seqResources, timeFilter, context, false);
    }

    @Override
    public boolean constructNextReader(int idx) throws IOException {
        TsFileResource tsFileResource = this.seqResources.get(idx);
        if (tsFileResource.isClosed()) {
            if (this.isTsFileNotSatisfied(tsFileResource, this.filter)) {
                return false;
            }
            this.currentSeriesReader = this.initSealedTsFileReader(tsFileResource, this.filter, this.context);
            return true;
        }
        if (tsFileResource.getEndTimeMap().size() != 0 && this.isTsFileNotSatisfied(tsFileResource, this.filter)) {
            return false;
        }
        this.currentSeriesReader = new UnSealedTsFileIterateReader(tsFileResource, this.filter, this.enableReverse);
        return true;
    }

    private boolean isTsFileNotSatisfied(TsFileResource tsFile, Filter filter) {
        long endTime;
        if (filter == null) {
            return false;
        }
        long startTime = tsFile.getStartTimeMap().get(this.seriesPath.getDevice());
        return !filter.satisfyStartEndTime(startTime, endTime = tsFile.getEndTimeMap().get(this.seriesPath.getDevice()).longValue());
    }

    private IAggregateReader initSealedTsFileReader(TsFileResource sealedTsFile, Filter filter, QueryContext context) throws IOException {
        TsFileSequenceReader tsFileReader = FileReaderManager.getInstance().get(sealedTsFile.getFile().getPath(), true);
        MetadataQuerierByFileImpl metadataQuerier = new MetadataQuerierByFileImpl(tsFileReader);
        List metaDataList = metadataQuerier.getChunkMetaDataList(this.seriesPath);
        List<Modification> pathModifications = context.getPathModifications(sealedTsFile.getModFile(), this.seriesPath.getFullPath());
        if (!pathModifications.isEmpty()) {
            QueryUtils.modifyChunkMetaData(metaDataList, pathModifications);
        }
        if (this.enableReverse) {
            Collections.reverse(metaDataList);
        }
        ChunkLoaderImpl chunkLoader = new ChunkLoaderImpl(tsFileReader);
        Object fileSeriesReader = filter == null ? new FileSeriesReaderWithoutFilter((ChunkLoader)chunkLoader, metaDataList) : new FileSeriesReaderWithFilter((ChunkLoader)chunkLoader, metaDataList, filter);
        return new FileSeriesReaderAdapter((FileSeriesReader)fileSeriesReader);
    }
}

