/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.chunkRelated;

import java.io.IOException;
import org.apache.iotdb.db.query.reader.IPointReader;
import org.apache.iotdb.db.utils.TimeValuePair;
import org.apache.iotdb.db.utils.TimeValuePairUtils;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.reader.chunk.ChunkReader;

public class DiskChunkReader
implements IPointReader {
    private ChunkReader chunkReader;
    private BatchData data;

    public DiskChunkReader(ChunkReader chunkReader) {
        this.chunkReader = chunkReader;
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.data != null && this.data.hasNext()) {
            return true;
        }
        while (this.chunkReader.hasNextBatch()) {
            this.data = this.chunkReader.nextBatch();
            if (!this.data.hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public TimeValuePair next() {
        TimeValuePair timeValuePair = TimeValuePairUtils.getCurrentTimeValuePair(this.data);
        this.data.next();
        return timeValuePair;
    }

    @Override
    public TimeValuePair current() {
        return TimeValuePairUtils.getCurrentTimeValuePair(this.data);
    }

    @Override
    public void close() {
        this.chunkReader.close();
    }
}

