/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.executor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.exception.PathErrorException;
import org.apache.iotdb.db.exception.ProcessorException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.query.aggregation.AggreResultData;
import org.apache.iotdb.db.query.aggregation.AggregateFunction;
import org.apache.iotdb.db.query.aggregation.impl.LastAggrFunc;
import org.apache.iotdb.db.query.aggregation.impl.MaxTimeAggrFunc;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.dataset.AggreResultDataPointReader;
import org.apache.iotdb.db.query.dataset.EngineDataSetWithoutValueFilter;
import org.apache.iotdb.db.query.factory.AggreFuncFactory;
import org.apache.iotdb.db.query.reader.IAggregateReader;
import org.apache.iotdb.db.query.reader.IPointReader;
import org.apache.iotdb.db.query.reader.IReaderByTimestamp;
import org.apache.iotdb.db.query.reader.resourceRelated.SeqResourceIterateReader;
import org.apache.iotdb.db.query.reader.resourceRelated.UnseqResourceMergeReader;
import org.apache.iotdb.db.query.reader.seriesRelated.SeriesReaderByTimestamp;
import org.apache.iotdb.db.query.timegenerator.EngineTimeGenerator;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.impl.GlobalTimeExpression;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;

public class AggregateEngineExecutor {
    private List<Path> selectedSeries;
    private List<String> aggres;
    private IExpression expression;
    private int aggregateFetchSize;

    public AggregateEngineExecutor(List<Path> selectedSeries, List<String> aggres, IExpression expression) {
        this.selectedSeries = selectedSeries;
        this.aggres = aggres;
        this.expression = expression;
        this.aggregateFetchSize = 10 * IoTDBDescriptor.getInstance().getConfig().getFetchSize();
    }

    public QueryDataSet executeWithoutValueFilter(QueryContext context) throws StorageEngineException, IOException, PathErrorException, ProcessorException {
        Filter timeFilter = null;
        if (this.expression != null) {
            timeFilter = ((GlobalTimeExpression)this.expression).getFilter();
        }
        QueryResourceManager.getInstance().beginQueryOfGivenQueryPaths(context.getJobId(), this.selectedSeries);
        ArrayList<SeqResourceIterateReader> readersOfSequenceData = new ArrayList<SeqResourceIterateReader>();
        ArrayList<UnseqResourceMergeReader> readersOfUnSequenceData = new ArrayList<UnseqResourceMergeReader>();
        ArrayList<AggregateFunction> aggregateFunctions = new ArrayList<AggregateFunction>();
        for (int i = 0; i < this.selectedSeries.size(); ++i) {
            TSDataType tsDataType = MManager.getInstance().getSeriesType(this.selectedSeries.get(i).getFullPath());
            AggregateFunction function = AggreFuncFactory.getAggrFuncByName(this.aggres.get(i), tsDataType);
            function.init();
            aggregateFunctions.add(function);
            QueryDataSource queryDataSource = QueryResourceManager.getInstance().getQueryDataSource(this.selectedSeries.get(i), context);
            SeqResourceIterateReader seqResourceIterateReader = function instanceof MaxTimeAggrFunc || function instanceof LastAggrFunc ? new SeqResourceIterateReader(queryDataSource.getSeriesPath(), queryDataSource.getSeqResources(), timeFilter, context, true) : new SeqResourceIterateReader(queryDataSource.getSeriesPath(), queryDataSource.getSeqResources(), timeFilter, context, false);
            UnseqResourceMergeReader unseqResourceMergeReader = new UnseqResourceMergeReader(queryDataSource.getSeriesPath(), queryDataSource.getUnseqResources(), context, timeFilter);
            readersOfSequenceData.add(seqResourceIterateReader);
            readersOfUnSequenceData.add(unseqResourceMergeReader);
        }
        ArrayList<AggreResultData> aggreResultDataList = new ArrayList<AggreResultData>();
        for (int i = 0; i < this.selectedSeries.size(); ++i) {
            AggreResultData aggreResultData = this.aggregateWithoutValueFilter((AggregateFunction)aggregateFunctions.get(i), (IAggregateReader)readersOfSequenceData.get(i), (IPointReader)readersOfUnSequenceData.get(i), timeFilter);
            aggreResultDataList.add(aggreResultData);
        }
        return this.constructDataSet(aggreResultDataList);
    }

    private AggreResultData aggregateWithoutValueFilter(AggregateFunction function, IAggregateReader sequenceReader, IPointReader unSequenceReader, Filter filter) throws IOException, ProcessorException {
        if (function instanceof MaxTimeAggrFunc || function instanceof LastAggrFunc) {
            return this.handleLastMaxTimeWithOutTimeGenerator(function, sequenceReader, unSequenceReader, filter);
        }
        while (sequenceReader.hasNext()) {
            PageHeader pageHeader = sequenceReader.nextPageHeader();
            if (this.canUseHeader(function, pageHeader, unSequenceReader, filter)) {
                function.calculateValueFromPageHeader(pageHeader);
                sequenceReader.skipPageData();
            } else {
                function.calculateValueFromPageData(sequenceReader.nextBatch(), unSequenceReader);
            }
            if (!function.isCalculatedAggregationResult()) continue;
            return function.getResult();
        }
        if (unSequenceReader.hasNext()) {
            function.calculateValueFromUnsequenceReader(unSequenceReader);
        }
        return function.getResult();
    }

    private boolean canUseHeader(AggregateFunction function, PageHeader pageHeader, IPointReader unSequenceReader, Filter filter) throws IOException, ProcessorException {
        if (pageHeader == null) {
            return false;
        }
        long minTime = pageHeader.getMinTimestamp();
        long maxTime = pageHeader.getMaxTimestamp();
        if (filter != null && !filter.containStartEndTime(minTime, maxTime)) {
            return false;
        }
        function.calculateValueFromUnsequenceReader(unSequenceReader, minTime);
        return !unSequenceReader.hasNext() || unSequenceReader.current().getTimestamp() > maxTime;
    }

    private AggreResultData handleLastMaxTimeWithOutTimeGenerator(AggregateFunction function, IAggregateReader sequenceReader, IPointReader unSequenceReader, Filter timeFilter) throws IOException, ProcessorException {
        long lastBatchTimeStamp = Long.MIN_VALUE;
        boolean isChunkEnd = false;
        while (sequenceReader.hasNext()) {
            PageHeader pageHeader = sequenceReader.nextPageHeader();
            if (this.canUseHeader(function, pageHeader, unSequenceReader, timeFilter)) {
                function.calculateValueFromPageHeader(pageHeader);
                sequenceReader.skipPageData();
                if (lastBatchTimeStamp > pageHeader.getMinTimestamp()) {
                    isChunkEnd = true;
                } else {
                    lastBatchTimeStamp = pageHeader.getMinTimestamp();
                }
            } else {
                BatchData batchData = sequenceReader.nextBatch();
                if (lastBatchTimeStamp > batchData.currentTime()) {
                    isChunkEnd = true;
                } else {
                    lastBatchTimeStamp = batchData.currentTime();
                }
                function.calculateValueFromPageData(batchData, unSequenceReader);
            }
            if (!isChunkEnd) continue;
            break;
        }
        if (unSequenceReader.hasNext()) {
            function.calculateValueFromUnsequenceReader(unSequenceReader);
        }
        return function.getResult();
    }

    public QueryDataSet executeWithValueFilter(QueryContext context) throws StorageEngineException, PathErrorException, IOException, ProcessorException {
        QueryResourceManager.getInstance().beginQueryOfGivenQueryPaths(context.getJobId(), this.selectedSeries);
        QueryResourceManager.getInstance().beginQueryOfGivenExpression(context.getJobId(), this.expression);
        EngineTimeGenerator timestampGenerator = new EngineTimeGenerator(this.expression, context);
        ArrayList<IReaderByTimestamp> readersOfSelectedSeries = new ArrayList<IReaderByTimestamp>();
        for (Path path : this.selectedSeries) {
            SeriesReaderByTimestamp seriesReaderByTimestamp = new SeriesReaderByTimestamp(path, context);
            readersOfSelectedSeries.add(seriesReaderByTimestamp);
        }
        ArrayList<AggregateFunction> aggregateFunctions = new ArrayList<AggregateFunction>();
        for (int i = 0; i < this.selectedSeries.size(); ++i) {
            TSDataType type = MManager.getInstance().getSeriesType(this.selectedSeries.get(i).getFullPath());
            AggregateFunction function = AggreFuncFactory.getAggrFuncByName(this.aggres.get(i), type);
            function.init();
            aggregateFunctions.add(function);
        }
        List<AggreResultData> batchDataList = this.aggregateWithValueFilter(aggregateFunctions, timestampGenerator, readersOfSelectedSeries);
        return this.constructDataSet(batchDataList);
    }

    private List<AggreResultData> aggregateWithValueFilter(List<AggregateFunction> aggregateFunctions, EngineTimeGenerator timestampGenerator, List<IReaderByTimestamp> readersOfSelectedSeries) throws IOException {
        while (timestampGenerator.hasNext()) {
            long[] timeArray = new long[this.aggregateFetchSize];
            int timeArrayLength = 0;
            for (int cnt = 0; cnt < this.aggregateFetchSize && timestampGenerator.hasNext(); ++cnt) {
                timeArray[timeArrayLength++] = timestampGenerator.next();
            }
            for (int i = 0; i < readersOfSelectedSeries.size(); ++i) {
                aggregateFunctions.get(i).calcAggregationUsingTimestamps(timeArray, timeArrayLength, readersOfSelectedSeries.get(i));
            }
        }
        ArrayList<AggreResultData> aggreResultDataArrayList = new ArrayList<AggreResultData>();
        for (AggregateFunction function : aggregateFunctions) {
            aggreResultDataArrayList.add(function.getResult());
        }
        return aggreResultDataArrayList;
    }

    private QueryDataSet constructDataSet(List<AggreResultData> aggreResultDataList) throws IOException {
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        ArrayList<IPointReader> resultDataPointReaders = new ArrayList<IPointReader>();
        for (AggreResultData resultData : aggreResultDataList) {
            dataTypes.add(resultData.getDataType());
            resultDataPointReaders.add(new AggreResultDataPointReader(resultData));
        }
        return new EngineDataSetWithoutValueFilter(this.selectedSeries, dataTypes, resultDataPointReaders);
    }
}

