/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset.groupby;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.PathErrorException;
import org.apache.iotdb.db.exception.ProcessorException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.query.aggregation.AggregateFunction;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.dataset.groupby.GroupByEngineDataSet;
import org.apache.iotdb.db.query.reader.IReaderByTimestamp;
import org.apache.iotdb.db.query.reader.seriesRelated.SeriesReaderByTimestamp;
import org.apache.iotdb.db.query.timegenerator.EngineTimeGenerator;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.query.timegenerator.TimeGenerator;
import org.apache.iotdb.tsfile.utils.Pair;

public class GroupByWithValueFilterDataSet
extends GroupByEngineDataSet {
    private List<IReaderByTimestamp> allDataReaderList = new ArrayList<IReaderByTimestamp>();
    private TimeGenerator timestampGenerator;
    private long timestamp;
    private boolean hasCachedTimestamp;
    private int timeStampFetchSize = 10 * IoTDBDescriptor.getInstance().getConfig().getFetchSize();

    public GroupByWithValueFilterDataSet(long jobId, List<Path> paths, long unit, long origin, List<Pair<Long, Long>> mergedIntervals) {
        super(jobId, paths, unit, origin, mergedIntervals);
    }

    public void initGroupBy(QueryContext context, List<String> aggres, IExpression expression) throws StorageEngineException, PathErrorException, ProcessorException, IOException {
        this.initAggreFuction(aggres);
        QueryResourceManager.getInstance().beginQueryOfGivenExpression(context.getJobId(), expression);
        QueryResourceManager.getInstance().beginQueryOfGivenQueryPaths(context.getJobId(), this.selectedSeries);
        this.timestampGenerator = new EngineTimeGenerator(expression, context);
        this.allDataReaderList = new ArrayList<IReaderByTimestamp>();
        for (Path path : this.selectedSeries) {
            SeriesReaderByTimestamp seriesReaderByTimestamp = new SeriesReaderByTimestamp(path, context);
            this.allDataReaderList.add(seriesReaderByTimestamp);
        }
    }

    public RowRecord next() throws IOException {
        int i;
        if (!this.hasCachedTimeInterval) {
            throw new IOException("need to call hasNext() before calling next() in GroupByWithoutValueFilterDataSet.");
        }
        this.hasCachedTimeInterval = false;
        for (AggregateFunction function : this.functions) {
            function.init();
        }
        long[] timestampArray = new long[this.timeStampFetchSize];
        int timeArrayLength = 0;
        if (this.hasCachedTimestamp) {
            if (this.timestamp < this.endTime) {
                this.hasCachedTimestamp = false;
                timestampArray[timeArrayLength++] = this.timestamp;
            } else {
                return this.constructRowRecord();
            }
        }
        while (this.timestampGenerator.hasNext()) {
            timeArrayLength = this.constructTimeArrayForOneCal(timestampArray, timeArrayLength);
            for (i = 0; i < this.selectedSeries.size(); ++i) {
                ((AggregateFunction)this.functions.get(i)).calcAggregationUsingTimestamps(timestampArray, timeArrayLength, this.allDataReaderList.get(i));
            }
            timeArrayLength = 0;
            if (this.timestamp < this.endTime) continue;
            this.hasCachedTimestamp = true;
            break;
        }
        if (timeArrayLength > 0) {
            for (i = 0; i < this.selectedSeries.size(); ++i) {
                ((AggregateFunction)this.functions.get(i)).calcAggregationUsingTimestamps(timestampArray, timeArrayLength, this.allDataReaderList.get(i));
            }
        }
        return this.constructRowRecord();
    }

    private int constructTimeArrayForOneCal(long[] timestampArray, int timeArrayLength) throws IOException {
        for (int cnt = 1; cnt < this.timeStampFetchSize && this.timestampGenerator.hasNext(); ++cnt) {
            this.timestamp = this.timestampGenerator.next();
            if (this.timestamp >= this.endTime) {
                this.hasCachedTimestamp = true;
                break;
            }
            timestampArray[timeArrayLength++] = this.timestamp;
        }
        return timeArrayLength;
    }

    private RowRecord constructRowRecord() {
        RowRecord record = new RowRecord(this.startTime);
        this.functions.forEach(function -> record.addField(this.getField(function.getResult())));
        return record;
    }
}

