/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.control;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.db.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.service.IService;
import org.apache.iotdb.db.service.ServiceType;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.UnClosedTsFileReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileReaderManager
implements IService {
    private static final Logger logger = LoggerFactory.getLogger(FileReaderManager.class);
    private static final int MAX_CACHED_FILE_SIZE = 30000;
    private ConcurrentHashMap<String, TsFileSequenceReader> closedFileReaderMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, TsFileSequenceReader> unclosedFileReaderMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, AtomicInteger> closedReferenceMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, AtomicInteger> unclosedReferenceMap = new ConcurrentHashMap();
    private ScheduledExecutorService executorService = IoTDBThreadPoolFactory.newScheduledThreadPool(1, "opended-files-manager");

    private FileReaderManager() {
        this.clearUnUsedFilesInFixTime();
    }

    public static FileReaderManager getInstance() {
        return FileReaderManagerHelper.INSTANCE;
    }

    private void clearUnUsedFilesInFixTime() {
        long examinePeriod = IoTDBDescriptor.getInstance().getConfig().getCacheFileReaderClearPeriod();
        this.executorService.scheduleAtFixedRate(() -> {
            FileReaderManager fileReaderManager = this;
            synchronized (fileReaderManager) {
                this.clearMap(this.closedFileReaderMap, this.closedReferenceMap);
                this.clearMap(this.unclosedFileReaderMap, this.unclosedReferenceMap);
            }
        }, 0L, examinePeriod, TimeUnit.MILLISECONDS);
    }

    private void clearMap(Map<String, TsFileSequenceReader> readerMap, Map<String, AtomicInteger> refMap) {
        for (Map.Entry<String, TsFileSequenceReader> entry : readerMap.entrySet()) {
            TsFileSequenceReader reader = entry.getValue();
            AtomicInteger refAtom = refMap.get(entry.getKey());
            if (refAtom == null || refAtom.get() != 0) continue;
            try {
                reader.close();
            }
            catch (IOException e) {
                logger.error("Can not close TsFileSequenceReader {} !", (Object)reader.getFileName(), (Object)e);
            }
            readerMap.remove(entry.getKey());
            refMap.remove(entry.getKey());
        }
    }

    public synchronized TsFileSequenceReader get(String filePath, boolean isClosed) throws IOException {
        ConcurrentHashMap<String, TsFileSequenceReader> readerMap;
        ConcurrentHashMap<String, TsFileSequenceReader> concurrentHashMap = readerMap = !isClosed ? this.unclosedFileReaderMap : this.closedFileReaderMap;
        if (!readerMap.containsKey(filePath)) {
            if (readerMap.size() >= 30000) {
                logger.warn("Query has opened {} files !", (Object)readerMap.size());
            }
            UnClosedTsFileReader tsFileReader = !isClosed ? new UnClosedTsFileReader(filePath) : new TsFileSequenceReader(filePath);
            readerMap.put(filePath, (TsFileSequenceReader)tsFileReader);
            return tsFileReader;
        }
        return (TsFileSequenceReader)readerMap.get(filePath);
    }

    public synchronized void increaseFileReaderReference(String filePath, boolean isClosed) {
        if (!isClosed) {
            this.unclosedReferenceMap.computeIfAbsent(filePath, k -> new AtomicInteger()).getAndIncrement();
        } else {
            this.closedReferenceMap.computeIfAbsent(filePath, k -> new AtomicInteger()).getAndIncrement();
        }
    }

    public synchronized void decreaseFileReaderReference(String filePath, boolean isClosed) {
        if (!isClosed && this.unclosedReferenceMap.containsKey(filePath)) {
            this.unclosedReferenceMap.get(filePath).getAndDecrement();
        } else if (this.closedReferenceMap.containsKey(filePath)) {
            this.closedReferenceMap.get(filePath).getAndDecrement();
        }
    }

    public synchronized void closeFileAndRemoveReader(String filePath) throws IOException {
        if (this.unclosedFileReaderMap.containsKey(filePath)) {
            this.unclosedReferenceMap.remove(filePath);
            this.unclosedFileReaderMap.get(filePath).close();
            this.unclosedFileReaderMap.remove(filePath);
        }
        if (this.closedFileReaderMap.containsKey(filePath)) {
            this.closedReferenceMap.remove(filePath);
            this.closedFileReaderMap.get(filePath).close();
            this.closedFileReaderMap.remove(filePath);
        }
    }

    public synchronized void closeAndRemoveAllOpenedReaders() throws IOException {
        for (Map.Entry<String, TsFileSequenceReader> entry : this.closedFileReaderMap.entrySet()) {
            entry.getValue().close();
            this.closedReferenceMap.remove(entry.getKey());
            this.closedFileReaderMap.remove(entry.getKey());
        }
        for (Map.Entry<String, TsFileSequenceReader> entry : this.unclosedFileReaderMap.entrySet()) {
            entry.getValue().close();
            this.unclosedReferenceMap.remove(entry.getKey());
            this.unclosedFileReaderMap.remove(entry.getKey());
        }
    }

    public synchronized boolean contains(String filePath, boolean isClosed) {
        return isClosed && this.closedFileReaderMap.containsKey(filePath) || !isClosed && this.unclosedFileReaderMap.containsKey(filePath);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        if (this.executorService == null || this.executorService.isShutdown()) {
            return;
        }
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.error("StatMonitor timing service could not be shutdown.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public ServiceType getID() {
        return ServiceType.FILE_READER_MANAGER_SERVICE;
    }

    private static class FileReaderManagerHelper {
        private static final FileReaderManager INSTANCE = new FileReaderManager();

        private FileReaderManagerHelper() {
        }
    }
}

