/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.aggregation.impl;

import java.io.IOException;
import org.apache.iotdb.db.query.aggregation.AggreResultData;
import org.apache.iotdb.db.query.aggregation.AggregateFunction;
import org.apache.iotdb.db.query.reader.IPointReader;
import org.apache.iotdb.db.query.reader.IReaderByTimestamp;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountAggrFunc
extends AggregateFunction {
    private static final Logger logger = LoggerFactory.getLogger(CountAggrFunc.class);

    public CountAggrFunc() {
        super(TSDataType.INT64);
    }

    @Override
    public void init() {
        this.resultData.reset();
        this.resultData.setTimestamp(0L);
        this.resultData.setLongRet(0L);
    }

    @Override
    public AggreResultData getResult() {
        return this.resultData;
    }

    @Override
    public void calculateValueFromPageHeader(PageHeader pageHeader) {
        if (logger.isDebugEnabled()) {
            logger.debug("PageHeader>>>>>>>>>>>>num of rows:{}, minTimeStamp:{}, maxTimeStamp{}", new Object[]{pageHeader.getNumOfValues(), pageHeader.getMinTimestamp(), pageHeader.getMaxTimestamp()});
        }
        long preValue = this.resultData.getLongRet();
        this.resultData.setLongRet(preValue += (long)pageHeader.getNumOfValues());
    }

    @Override
    public void calculateValueFromPageData(BatchData dataInThisPage, IPointReader unsequenceReader) throws IOException {
        this.calculateValueFromPageData(dataInThisPage, unsequenceReader, false, 0L);
    }

    @Override
    public void calculateValueFromPageData(BatchData dataInThisPage, IPointReader unsequenceReader, long bound) throws IOException {
        this.calculateValueFromPageData(dataInThisPage, unsequenceReader, true, bound);
    }

    private void calculateValueFromPageData(BatchData dataInThisPage, IPointReader unsequenceReader, boolean hasBound, long bound) throws IOException {
        int cnt = 0;
        while (dataInThisPage.hasNext() && unsequenceReader.hasNext()) {
            long minTimestamp = Math.min(dataInThisPage.currentTime(), unsequenceReader.current().getTimestamp());
            if (hasBound && minTimestamp >= bound) break;
            if (dataInThisPage.currentTime() == unsequenceReader.current().getTimestamp()) {
                dataInThisPage.next();
                unsequenceReader.next();
            } else if (dataInThisPage.currentTime() < unsequenceReader.current().getTimestamp()) {
                dataInThisPage.next();
            } else {
                unsequenceReader.next();
            }
            ++cnt;
        }
        while (dataInThisPage.hasNext() && (!hasBound || dataInThisPage.currentTime() < bound)) {
            dataInThisPage.next();
            ++cnt;
        }
        long preValue = this.resultData.getLongRet();
        this.resultData.setLongRet(preValue += (long)cnt);
    }

    @Override
    public void calculateValueFromUnsequenceReader(IPointReader unsequenceReader) throws IOException {
        int cnt = 0;
        while (unsequenceReader.hasNext()) {
            unsequenceReader.next();
            ++cnt;
        }
        long preValue = this.resultData.getLongRet();
        this.resultData.setLongRet(preValue += (long)cnt);
    }

    @Override
    public void calculateValueFromUnsequenceReader(IPointReader unsequenceReader, long bound) throws IOException {
        int cnt = 0;
        while (unsequenceReader.hasNext() && unsequenceReader.current().getTimestamp() < bound) {
            unsequenceReader.next();
            ++cnt;
        }
        long preValue = this.resultData.getLongRet();
        this.resultData.setLongRet(preValue += (long)cnt);
    }

    @Override
    public void calcAggregationUsingTimestamps(long[] timestamps, int length, IReaderByTimestamp dataReader) throws IOException {
        int cnt = 0;
        for (int i = 0; i < length; ++i) {
            Object value = dataReader.getValueInTimestamp(timestamps[i]);
            if (value == null) continue;
            ++cnt;
        }
        long preValue = this.resultData.getLongRet();
        this.resultData.setLongRet(preValue += (long)cnt);
    }

    @Override
    public boolean isCalculatedAggregationResult() {
        return false;
    }
}

